/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.Curve;

public class ReferenceGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = -8810905237933499989L;
    private Curve curve;
    private String role;
    private String glyph;

    public ReferenceGlyph() {
        this.initDefaults();
    }

    public ReferenceGlyph(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public ReferenceGlyph(ReferenceGlyph speciesReferenceGlyph) {
        super(speciesReferenceGlyph);
        if (speciesReferenceGlyph.isSetCurve()) {
            this.setCurve(speciesReferenceGlyph.getCurve().clone());
        }
        if (speciesReferenceGlyph.isSetRole()) {
            this.setRole(speciesReferenceGlyph.getRole());
        }
        if (speciesReferenceGlyph.isSetGlyph()) {
            this.setGlyph(new String(speciesReferenceGlyph.getGlyph()));
        }
    }

    public ReferenceGlyph(String id) {
        super(id);
        this.initDefaults();
    }

    public ReferenceGlyph(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    @Override
    public ReferenceGlyph clone() {
        return new ReferenceGlyph(this);
    }

    public Curve createCurve() {
        if (this.isSetCurve()) {
            this.unsetCurve();
        }
        this.setCurve(new Curve(this.getLevel(), this.getVersion()));
        return this.getCurve();
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            ReferenceGlyph s = (ReferenceGlyph)object;
            if ((equals &= s.isSetRole() && this.isSetRole()) && this.isSetRole()) {
                equals &= s.getRole().equals(this.getRole());
            }
            if ((equals &= s.isSetGlyph() == this.isSetGlyph()) && this.isSetGlyph()) {
                equals &= s.getGlyph().equals(this.getGlyph());
            }
        }
        return equals;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetCurve()) {
            if (pos == index) {
                return this.getCurve();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetCurve()) {
            ++count;
        }
        return count;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public String getGlyph() {
        return this.glyph;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public int hashCode() {
        int prime = 953;
        int hashCode = super.hashCode();
        if (this.isSetRole()) {
            hashCode += 953 * this.getRole().hashCode();
        }
        if (this.isSetGlyph()) {
            hashCode += 953 * this.getGlyph().hashCode();
        }
        return hashCode;
    }

    public boolean isSetCurve() {
        return this.curve != null;
    }

    public boolean isSetGlyph() {
        return this.glyph != null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public boolean isSetReferenceInstance() {
        return this.getReferenceInstance() != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("reference")) {
                this.setReference(value);
            } else if (attributeName.equals("glyph")) {
                this.setGlyph(value);
            } else if (attributeName.equals("role")) {
                this.setRole(value);
            } else {
                return false;
            }
        }
        return isAttributeRead;
    }

    public void setCurve(Curve curve) {
        Curve oldCurve = this.curve;
        this.curve = curve;
        this.firePropertyChange("curve", oldCurve, this.role);
        this.registerChild((SBase)this.curve);
    }

    public void setRole(String role) {
        String oldRole = this.role;
        this.role = role;
        this.firePropertyChange("role", oldRole, this.role);
    }

    public void setGlyph(String glyph) {
        String oldValue = this.glyph;
        this.glyph = glyph;
        this.firePropertyChange("speciesGlyph", oldValue, this.glyph);
    }

    @Override
    public boolean setReference(String reference) {
        return this.setReference(reference, "reference");
    }

    public boolean unsetCurve() {
        if (this.isSetCurve()) {
            Curve oldCurve = this.getCurve();
            this.curve = null;
            oldCurve.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetGlyph()) {
            attributes.put("layout:glyph", this.glyph);
        }
        if (this.isSetReference()) {
            attributes.put("layout:reference", this.getReference());
        }
        if (this.isSetRole()) {
            attributes.put("layout:role", this.role);
        }
        return attributes;
    }
}

