/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;
import org.sbml.jsbml.xml.XMLNode;

public class CompartmentGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020501, 6020510);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020501: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020502: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020503: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        return new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)compartmentGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)compartmentGlyph);
                    }
                };
                break;
            }
            case 6020504: {
                func = new UnknownPackageAttributeValidationFunction<CompartmentGlyph>("layout"){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (!compartmentGlyph.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)compartmentGlyph);
                    }
                };
                break;
            }
            case 6020505: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (compartmentGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)compartmentGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020506: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (compartmentGlyph.isSetMetaidRef()) {
                            return compartmentGlyph.getSBMLDocument().getElementByMetaId(compartmentGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020507: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (compartmentGlyph.isSetCompartment()) {
                            return SyntaxChecker.isValidId((String)compartmentGlyph.getCompartment(), (int)compartmentGlyph.getLevel(), (int)compartmentGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020508: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (compartmentGlyph.isSetCompartment()) {
                            return compartmentGlyph.getModel().getCompartment(compartmentGlyph.getCompartment()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020509: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        if (compartmentGlyph.isSetCompartment() && compartmentGlyph.isSetMetaidRef()) {
                            try {
                                Compartment c = compartmentGlyph.getModel().getCompartment(compartmentGlyph.getCompartment());
                                Compartment cFromRef = (Compartment)compartmentGlyph.getSBMLDocument().getElementByMetaId(compartmentGlyph.getMetaidRef());
                                if ((c == null || cFromRef == null) && c != cFromRef) {
                                    return false;
                                }
                                if (c == null || cFromRef == null || !c.equals((Object)cFromRef)) {
                                    return false;
                                }
                            }
                            catch (ClassCastException e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020510: {
                func = new ValidationFunction<CompartmentGlyph>(){

                    public boolean check(ValidationContext ctx, CompartmentGlyph compartmentGlyph) {
                        XMLNode unknown;
                        return compartmentGlyph.isSetOrder() || compartmentGlyph.getUserObject("jsbml.unknown.xml") == null || (unknown = (XMLNode)compartmentGlyph.getUserObject("jsbml.unknown.xml")).getAttrIndex("order") == -1;
                    }
                };
            }
        }
        return func;
    }
}

