/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CubicBezierConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021601, 6021604);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021601: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021602: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021603: {
                func = new ValidationFunction<CubicBezier>(){

                    public boolean check(ValidationContext ctx, CubicBezier cubicBezier) {
                        return cubicBezier.isSetStart() && cubicBezier.isSetEnd() && cubicBezier.isSetBasePoint1() && cubicBezier.isSetBasePoint2() && new DuplicatedElementValidationFunction("start").check(ctx, (SBase)cubicBezier) && new DuplicatedElementValidationFunction("end").check(ctx, (SBase)cubicBezier) && new DuplicatedElementValidationFunction("basePoint1").check(ctx, (SBase)cubicBezier) && new DuplicatedElementValidationFunction("basePoint2").check(ctx, (SBase)cubicBezier) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)cubicBezier);
                    }
                };
                break;
            }
            case 6021604: {
                func = new UnknownPackageAttributeValidationFunction("layout");
            }
        }
        return func;
    }
}

