/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;
import org.sbml.jsbml.xml.XMLNode;

public class DimensionsConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021701, 6021704);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021701: {
                func = new ValidationFunction<Dimensions>(){

                    public boolean check(ValidationContext ctx, Dimensions dimensions) {
                        return new UnknownCoreElementValidationFunction().check(ctx, (TreeNodeWithChangeSupport)dimensions) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)dimensions);
                    }
                };
                break;
            }
            case 6021702: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021703: {
                func = new UnknownPackageAttributeValidationFunction<Dimensions>("layout"){

                    public boolean check(ValidationContext ctx, Dimensions dimensions) {
                        if (!dimensions.isSetWidth() || !dimensions.isSetHeight()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)dimensions);
                    }
                };
                break;
            }
            case 6021704: {
                func = new ValidationFunction<Dimensions>(){

                    public boolean check(ValidationContext ctx, Dimensions dimensions) {
                        if (dimensions.getUserObject("jsbml.unknown.xml") != null) {
                            XMLNode unknown = (XMLNode)dimensions.getUserObject("jsbml.unknown.xml");
                            if (!dimensions.isSetWidth() && unknown.getAttrIndex("width") != -1) {
                                return false;
                            }
                            if (!dimensions.isSetHeight() && unknown.getAttrIndex("height") != -1) {
                                return false;
                            }
                            if (!dimensions.isSetDepth() && unknown.getAttrIndex("depth") != -1) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

