/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.GeneralGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class GeneralGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020801, 6020813);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020801: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020802: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020803: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        return new DuplicatedElementValidationFunction("listOfReferenceGlyphs").check(ctx, (SBase)generalGlyph) && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)generalGlyph) && new DuplicatedElementValidationFunction("curve").check(ctx, (SBase)generalGlyph) && new DuplicatedElementValidationFunction("listOfSubGlyphs").check(ctx, (SBase)generalGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)generalGlyph);
                    }
                };
                break;
            }
            case 6020804: {
                func = new UnknownPackageAttributeValidationFunction<GeneralGlyph>("layout"){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (!generalGlyph.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)generalGlyph);
                    }
                };
                break;
            }
            case 6020805: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)generalGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020806: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetMetaidRef()) {
                            return generalGlyph.getSBMLDocument().getElementByMetaId(generalGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020807: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetReference()) {
                            return SyntaxChecker.isValidId((String)generalGlyph.getReference(), (int)generalGlyph.getLevel(), (int)generalGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020808: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetReference()) {
                            return generalGlyph.getModel().getElementBySId(generalGlyph.getReference()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020809: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetReference() && generalGlyph.isSetMetaidRef()) {
                            SBase sbase = generalGlyph.getModel().getElementBySId(generalGlyph.getReference());
                            SBase sbaseFromMetaidRef = generalGlyph.getSBMLDocument().getElementByMetaId(generalGlyph.getMetaidRef());
                            if ((sbase == null || sbaseFromMetaidRef == null) && sbase != sbaseFromMetaidRef) {
                                return false;
                            }
                            if (sbase == null || sbaseFromMetaidRef == null || !sbase.equals((Object)sbaseFromMetaidRef)) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020810: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetListOfReferenceGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, generalGlyph.getListOfReferenceGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020811: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetListOfReferenceGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, generalGlyph.getListOfReferenceGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, generalGlyph.getListOfReferenceGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020812: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetListOfSubGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, generalGlyph.getListOfSubGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020813: {
                func = new ValidationFunction<GeneralGlyph>(){

                    public boolean check(ValidationContext ctx, GeneralGlyph generalGlyph) {
                        if (generalGlyph.isSetListOfSubGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, generalGlyph.getListOfSubGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, generalGlyph.getListOfSubGlyphs());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

