/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;

public class CubicBezier
extends LineSegment {
    private static final long serialVersionUID = -6747242964512145076L;
    private Point basePoint1;
    private Point basePoint2;

    public CubicBezier() {
        this.setType(CurveSegment.Type.CUBIC_BEZIER);
    }

    public CubicBezier(CubicBezier cubicBezier) {
        super(cubicBezier);
        if (cubicBezier.isSetBasePoint1()) {
            this.setBasePoint1(cubicBezier.getBasePoint1().clone());
        }
        if (cubicBezier.isSetBasePoint2()) {
            this.setBasePoint2(cubicBezier.getBasePoint2().clone());
        }
    }

    public CubicBezier(int level, int version) {
        super(level, version);
        this.setType(CurveSegment.Type.CUBIC_BEZIER);
    }

    @Override
    public CubicBezier clone() {
        return new CubicBezier(this);
    }

    public Point createBasePoint1() {
        Point p = new Point(this.getLevel(), this.getVersion());
        this.setBasePoint1(p);
        return p;
    }

    public Point createBasePoint1(double x, double y, double z) {
        Point p = new Point(this.getLevel(), this.getVersion());
        p.setX(x);
        p.setY(y);
        p.setZ(z);
        this.setBasePoint1(p);
        return p;
    }

    public Point createBasePoint2() {
        Point p = new Point(this.getLevel(), this.getVersion());
        this.setBasePoint2(p);
        return p;
    }

    public Point createBasePoint2(double x, double y, double z) {
        Point p = new Point(this.getLevel(), this.getVersion());
        p.setX(x);
        p.setY(y);
        p.setZ(z);
        this.setBasePoint2(p);
        return p;
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            CubicBezier cb = (CubicBezier)((Object)object);
            if ((equals &= cb.isSetBasePoint1() == this.isSetBasePoint1()) && this.isSetBasePoint1()) {
                equals &= cb.getBasePoint1().equals((Object)this.getBasePoint1());
            }
            if ((equals &= cb.isSetBasePoint2() == this.isSetBasePoint2()) && cb.isSetBasePoint2()) {
                equals &= cb.getBasePoint2().equals((Object)this.getBasePoint2());
            }
        }
        return equals;
    }

    public Point getBasePoint1() {
        return this.basePoint1;
    }

    public Point getBasePoint2() {
        return this.basePoint2;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetBasePoint1()) {
            if (pos == index) {
                return this.getBasePoint1();
            }
            ++pos;
        }
        if (this.isSetBasePoint2()) {
            if (pos == index) {
                return this.getBasePoint2();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetBasePoint1()) {
            ++count;
        }
        if (this.isSetBasePoint2()) {
            ++count;
        }
        return count;
    }

    @Override
    public int hashCode() {
        int prime = 919;
        int hashCode = super.hashCode();
        if (this.isSetBasePoint1()) {
            hashCode += 919 * this.getBasePoint1().hashCode();
        }
        if (this.isSetBasePoint2()) {
            hashCode += 919 * this.getBasePoint2().hashCode();
        }
        return hashCode;
    }

    public boolean isSetBasePoint1() {
        return this.basePoint1 != null;
    }

    public boolean isSetBasePoint2() {
        return this.basePoint2 != null;
    }

    public Point removeBasePoint1() {
        if (!this.isSetBasePoint1()) {
            return null;
        }
        Point bp1 = this.getBasePoint1();
        this.setBasePoint1(null);
        return bp1;
    }

    public Point removeBasePoint2() {
        if (!this.isSetBasePoint2()) {
            return null;
        }
        Point bp2 = this.getBasePoint2();
        this.setBasePoint2(null);
        return bp2;
    }

    public void setBasePoint1(Point basePoint1) {
        Point oldValue = this.basePoint1;
        if (this.basePoint1 != null) {
            this.basePoint1 = null;
            oldValue.fireNodeRemovedEvent();
        }
        this.basePoint1 = basePoint1;
        if (basePoint1 != null) {
            basePoint1.setElementName("basePoint1");
        }
        this.registerChild((SBase)this.basePoint1);
        this.firePropertyChange("basePoint1", (Object)oldValue, (Object)this.basePoint1);
    }

    public void setBasePoint2(Point basePoint2) {
        Point oldValue = this.basePoint2;
        if (this.basePoint2 != null) {
            this.basePoint2 = null;
            oldValue.fireNodeRemovedEvent();
        }
        this.basePoint2 = basePoint2;
        if (basePoint2 != null) {
            basePoint2.setElementName("basePoint2");
        }
        this.registerChild((SBase)this.basePoint2);
        this.firePropertyChange("basePoint2", (Object)oldValue, (Object)this.basePoint2);
    }

    public void unsetBasePoint1() {
        this.removeBasePoint1();
    }

    public void unsetBasePoint2() {
        this.removeBasePoint2();
    }
}

