/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.ICurve;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.layout.ReactionGlyph;

public class Curve
extends AbstractSBase
implements ICurve {
    private static final long serialVersionUID = -5435135643993920570L;
    ListOf<CurveSegment> listOfCurveSegments;

    public Curve() {
        this.initDefaults();
    }

    public Curve(Curve curve) {
        super((SBase)curve);
        if (curve.isSetListOfCurveSegments()) {
            this.setListOfCurveSegments((ListOf<CurveSegment>)curve.getListOfCurveSegments().clone());
        }
    }

    public Curve(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    @Override
    public boolean addCurveSegment(CurveSegment curveSegment) {
        return this.getListOfCurveSegments().add((SBase)curveSegment);
    }

    @Override
    public void addCurveSegment(int index, CurveSegment element) {
        this.getListOfCurveSegments().add(index, (SBase)element);
    }

    public Curve clone() {
        return new Curve(this);
    }

    public LineSegment createLineSegment() {
        LineSegment cs = new LineSegment(this.getLevel(), this.getVersion());
        this.addCurveSegment(cs);
        return cs;
    }

    public LineSegment createLineSegment(Point start, Point end) {
        LineSegment cs = this.createLineSegment();
        cs.setStart(start);
        cs.setEnd(end);
        return cs;
    }

    @Override
    public CubicBezier createCubicBezier() {
        CubicBezier cs = new CubicBezier(this.getLevel(), this.getVersion());
        this.addCurveSegment(cs);
        return cs;
    }

    public CubicBezier createCubicBezier(Point start, Point basePoint1, Point basePoint2, Point end) {
        CubicBezier cs = this.createCubicBezier();
        cs.setStart(start);
        cs.setBasePoint1(basePoint1);
        cs.setBasePoint2(basePoint2);
        cs.setEnd(end);
        return cs;
    }

    public boolean equals(Object object) {
        Curve curve;
        boolean equals = super.equals(object);
        if (equals && (equals &= (curve = (Curve)object).isSetListOfCurveSegments() == this.isSetListOfCurveSegments()) && this.isSetListOfCurveSegments()) {
            equals &= curve.getListOfCurveSegments().equals(this.getListOfCurveSegments());
        }
        return equals;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfCurveSegments()) {
            if (pos == index) {
                return this.getListOfCurveSegments();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfCurveSegments()) {
            ++count;
        }
        return count;
    }

    @Override
    public CurveSegment getCurveSegment(int n) {
        return (CurveSegment)this.getListOfCurveSegments().get(n);
    }

    @Override
    public int getCurveSegmentCount() {
        return this.isSetListOfCurveSegments() ? this.getListOfCurveSegments().size() : 0;
    }

    @Override
    public ListOf<CurveSegment> getListOfCurveSegments() {
        if (this.listOfCurveSegments == null) {
            this.listOfCurveSegments = new ListOf(this.getLevel(), this.getVersion());
            this.listOfCurveSegments.setPackageVersion(-1);
            this.listOfCurveSegments.setPackageName(null);
            this.listOfCurveSegments.setPackageName("layout");
            this.listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            this.listOfCurveSegments.setOtherListName("listOfCurveSegments");
            this.registerChild((SBase)this.listOfCurveSegments);
        }
        return this.listOfCurveSegments;
    }

    public int hashCode() {
        int prime = 929;
        int hashCode = super.hashCode();
        if (this.isSetListOfCurveSegments()) {
            hashCode += 929 * this.getListOfCurveSegments().hashCode();
        }
        return hashCode;
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public boolean isIdMandatory() {
        return false;
    }

    @Override
    public boolean isSetListOfCurveSegments() {
        return this.listOfCurveSegments != null && this.listOfCurveSegments.size() > 0;
    }

    @Override
    public boolean removeCurveSegment(CurveSegment cs) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(0));
        }
        return this.getListOfCurveSegments().remove((SBase)cs);
    }

    public CurveSegment removeCurveSegment(int i) {
        if (!this.isSetListOfCurveSegments()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CurveSegment)this.getListOfCurveSegments().remove(i);
    }

    @Override
    public void setListOfCurveSegments(ListOf<CurveSegment> listOfCurveSegments) {
        this.unsetListOfCurveSegments();
        this.listOfCurveSegments = listOfCurveSegments;
        if (this.listOfCurveSegments != null) {
            listOfCurveSegments.setPackageVersion(-1);
            listOfCurveSegments.setPackageName(null);
            listOfCurveSegments.setPackageName("layout");
            listOfCurveSegments.setSBaseListType(ListOf.Type.other);
            listOfCurveSegments.setOtherListName("listOfCurveSegments");
        }
        this.registerChild((SBase)this.listOfCurveSegments);
    }

    @Override
    public boolean unsetListOfCurveSegments() {
        if (this.listOfCurveSegments != null) {
            ListOf<CurveSegment> oldListOfCurveSegments = this.listOfCurveSegments;
            this.listOfCurveSegments = null;
            oldListOfCurveSegments.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public ReactionGlyph getParentReactionGlyph() {
        if (this.isSetParent() && this.getParent().isSetParent()) {
            return (ReactionGlyph)((Object)this.getParent().getParent());
        }
        return null;
    }
}

