/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.Point;

public abstract class CurveSegment
extends AbstractSBase {
    private static final long serialVersionUID = -5085246314333062152L;
    private static final transient Logger logger = Logger.getLogger(CurveSegment.class);
    private Type type;

    public CurveSegment() {
        this.initDefaults();
    }

    public CurveSegment(CurveSegment curveSegment) {
        super((SBase)curveSegment);
        if (curveSegment.isSetType()) {
            this.setType(curveSegment.getType());
        }
    }

    public CurveSegment(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public abstract Point createEnd();

    public abstract Point createEnd(double var1, double var3, double var5);

    public abstract Point createStart();

    public abstract Point createStart(double var1, double var3, double var5);

    public boolean equals(Object object) {
        CurveSegment curveSegment;
        boolean equals = super.equals(object);
        if (equals && (equals &= (curveSegment = (CurveSegment)((Object)object)).isSetType() == this.isSetType()) && this.isSetType()) {
            equals &= curveSegment.getType().equals((Object)this.getType());
        }
        return equals;
    }

    public abstract Point getEnd();

    public abstract Point getStart();

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 937;
        int hashCode = super.hashCode();
        if (this.isSetType()) {
            hashCode += 937 * this.getType().hashCode();
        }
        return hashCode;
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public boolean isCubicBezier() {
        return this.type != null && this.type.equals((Object)Type.CUBIC_BEZIER);
    }

    public boolean isLineSegment() {
        return this.type != null && this.type.equals((Object)Type.LINE_SEGMENT);
    }

    public abstract boolean isSetEnd();

    public abstract boolean isSetStart();

    public boolean isSetType() {
        return this.type != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        logger.debug((Object)("reading CurveSegmentImpl: " + prefix + ":" + attributeName));
        if (!isAttributeRead && attributeName.equals("type")) {
            try {
                this.setType(Type.fromString(value));
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "type" + " on the 'curveSegment' element.");
            }
            return true;
        }
        return isAttributeRead;
    }

    public Point removeEnd() {
        if (!this.isSetEnd()) {
            return null;
        }
        Point end = this.getEnd();
        this.setEnd(null);
        return end;
    }

    public Point removeStart() {
        if (!this.isSetStart()) {
            return null;
        }
        Point start = this.getStart();
        this.setStart(null);
        return start;
    }

    public abstract void setEnd(Point var1);

    public abstract void setStart(Point var1);

    void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.firePropertyChange("type", (Object)oldType, (Object)this.type);
    }

    public void unsetEnd() {
        Point oldValue = this.getEnd();
        if (oldValue != null) {
            this.removeEnd();
            this.firePropertyChange("end", (Object)oldValue, (Object)this.getEnd());
        }
    }

    public void unsetStart() {
        Point oldValue = this.getStart();
        if (oldValue != null) {
            this.removeStart();
            this.firePropertyChange("start", (Object)oldValue, (Object)this.getStart());
        }
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"process attributes of CurveSegmentImpl");
            logger.debug((Object)("isSetType: " + this.isSetType()));
            logger.debug((Object)("Type = " + (Object)((Object)this.type)));
        }
        if (this.isSetType()) {
            attributes.put("xsi:type", this.getType().toString());
        }
        return attributes;
    }

    public static enum Type {
        CUBIC_BEZIER("CubicBezier"),
        LINE_SEGMENT("LineSegment");

        private final String xmlString;

        public static Type fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            for (Type v : Type.values()) {
                if (!value.equalsIgnoreCase(v.getXmlString())) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }

        private Type(String xmlString) {
            this.xmlString = xmlString;
        }

        public String getXmlString() {
            return this.xmlString;
        }

        public String toString() {
            return this.xmlString;
        }
    }
}

