/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.IBoundingBox;
import org.sbml.jsbml.util.ResourceManager;

public class GraphicalObject
extends AbstractNamedSBase
implements UniqueNamedSBase,
IBoundingBox {
    private static final long serialVersionUID = 7587814013754302901L;
    private static final transient Logger logger = Logger.getLogger(GraphicalObject.class);
    private BoundingBox boundingBox;
    private String metaidRef;

    public GraphicalObject() {
        this.initDefaults();
    }

    public GraphicalObject(GraphicalObject graphicalObject) {
        super((AbstractNamedSBase)graphicalObject);
        if (graphicalObject.isSetBoundingBox()) {
            this.setBoundingBox(graphicalObject.getBoundingBox().clone());
        }
        if (graphicalObject.isSetMetaidRef()) {
            this.setMetaidRef(graphicalObject.getMetaidRef());
        }
    }

    public GraphicalObject(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public GraphicalObject(String id) {
        super(id);
        this.initDefaults();
    }

    public GraphicalObject(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    public GraphicalObject clone() {
        return new GraphicalObject(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    @Override
    public BoundingBox createBoundingBox() {
        BoundingBox bb = new BoundingBox();
        this.setBoundingBox(bb);
        return bb;
    }

    public BoundingBox createBoundingBox(Dimensions dimensions) {
        BoundingBox bb = this.createBoundingBox();
        bb.setDimensions(dimensions);
        return bb;
    }

    public BoundingBox createBoundingBox(double width, double height, double depth) {
        BoundingBox bb = this.createBoundingBox();
        bb.createDimensions(width, height, depth);
        return bb;
    }

    public BoundingBox createBoundingBox(double width, double height, double depth, double x, double y, double z) {
        BoundingBox bb = this.createBoundingBox(width, height, depth);
        bb.createPosition(x, y, z);
        return bb;
    }

    public boolean equals(Object object) {
        GraphicalObject graphicalObject;
        boolean equals = super.equals(object);
        if (equals && (equals &= (graphicalObject = (GraphicalObject)object).isSetBoundingBox() == this.isSetBoundingBox()) && this.isSetBoundingBox()) {
            equals &= graphicalObject.getBoundingBox().equals((Object)this.getBoundingBox());
        }
        return equals;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetBoundingBox()) {
            if (pos == index) {
                return this.getBoundingBox();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetBoundingBox()) {
            ++count;
        }
        return count;
    }

    public int hashCode() {
        int prime = 941;
        int hashCode = super.hashCode();
        if (this.isSetBoundingBox()) {
            hashCode += 941 * this.getBoundingBox().hashCode();
        }
        return hashCode;
    }

    public boolean isIdMandatory() {
        return true;
    }

    @Override
    public boolean isSetBoundingBox() {
        return this.boundingBox != null;
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        BoundingBox oldValue = this.boundingBox;
        this.boundingBox = boundingBox;
        this.registerChild((SBase)this.boundingBox);
        this.firePropertyChange("boundingBox", (Object)oldValue, (Object)this.boundingBox);
    }

    @Override
    public void unsetBoundingBox() {
        if (this.isSetBoundingBox()) {
            BoundingBox oldValue = this.boundingBox;
            this.boundingBox = null;
            oldValue.fireNodeRemovedEvent();
            this.firePropertyChange("boundingBox", (Object)oldValue, (Object)this.boundingBox);
        }
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("layout:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            logger.warn((Object)MessageFormat.format(ResourceManager.getBundle((String)"org.sbml.jsbml.resources.cfg.Messages").getString("UNDEFINED_ATTRIBUTE"), "name", this.getLevel(), this.getVersion(), this.getElementName()));
        }
        if (this.isSetMetaidRef()) {
            attributes.put("layout:metaidRef", this.getMetaidRef());
        }
        return attributes;
    }

    public String getMetaidRef() {
        if (this.isSetMetaidRef()) {
            return this.metaidRef;
        }
        return "";
    }

    public boolean isSetMetaidRef() {
        return this.metaidRef != null;
    }

    public void setMetaidRef(String metaidRef) {
        String oldMetaidRef = this.metaidRef;
        this.metaidRef = metaidRef;
        this.firePropertyChange("metaidRef", oldMetaidRef, this.metaidRef);
    }

    public boolean unsetMetaidRef() {
        if (this.isSetMetaidRef()) {
            String oldMetaidRef = this.metaidRef;
            this.metaidRef = null;
            this.firePropertyChange("metaidRef", oldMetaidRef, this.metaidRef);
            return true;
        }
        return false;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("metaidRef")) {
                this.setMetaidRef(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

