/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.Point;

public class LineSegment
extends CurveSegment {
    private static final long serialVersionUID = -5085246314333062152L;
    Point end;
    Point start;

    public LineSegment() {
        this.setType(CurveSegment.Type.LINE_SEGMENT);
    }

    public LineSegment(int level, int version) {
        super(level, version);
        this.setType(CurveSegment.Type.LINE_SEGMENT);
    }

    public LineSegment(LineSegment lineSegment) {
        super(lineSegment);
        if (lineSegment.isSetStart()) {
            this.setStart(lineSegment.getStart().clone());
        }
        if (lineSegment.isSetEnd()) {
            this.setEnd(lineSegment.getEnd().clone());
        }
    }

    public LineSegment(CurveSegment lineSegment) {
        super(lineSegment);
        if (lineSegment.isSetStart()) {
            this.setStart(lineSegment.getStart().clone());
        }
        if (lineSegment.isSetEnd()) {
            this.setEnd(lineSegment.getEnd().clone());
        }
        this.setType(CurveSegment.Type.LINE_SEGMENT);
    }

    public LineSegment clone() {
        return new LineSegment(this);
    }

    @Override
    public Point createEnd() {
        Point p = new Point(this.getLevel(), this.getVersion());
        this.setEnd(p);
        return p;
    }

    @Override
    public Point createEnd(double x, double y, double z) {
        Point p = new Point(this.getLevel(), this.getVersion());
        p.setX(x);
        p.setY(y);
        p.setZ(z);
        this.setEnd(p);
        return p;
    }

    @Override
    public Point createStart() {
        Point p = new Point(this.getLevel(), this.getVersion());
        this.setStart(p);
        return p;
    }

    @Override
    public Point createStart(double x, double y, double z) {
        Point p = new Point(this.getLevel(), this.getVersion());
        p.setX(x);
        p.setY(y);
        p.setZ(z);
        this.setStart(p);
        return p;
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            LineSegment lineSegment = (LineSegment)((Object)object);
            if ((equals &= lineSegment.isSetStart() == this.isSetStart()) && this.isSetStart()) {
                equals &= lineSegment.getStart().equals((Object)this.getStart());
            }
            if ((equals &= lineSegment.isSetEnd() == this.isSetEnd()) && lineSegment.isSetEnd()) {
                equals &= lineSegment.getEnd().equals((Object)this.getEnd());
            }
        }
        return equals;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetStart()) {
            if (pos == index) {
                return this.getStart();
            }
            ++pos;
        }
        if (this.isSetEnd()) {
            if (pos == index) {
                return this.getEnd();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetStart()) {
            ++count;
        }
        if (this.isSetEnd()) {
            ++count;
        }
        return count;
    }

    @Override
    public Point getEnd() {
        return this.end;
    }

    @Override
    public Point getStart() {
        return this.start;
    }

    @Override
    public int hashCode() {
        int prime = 911;
        int hashCode = super.hashCode();
        if (this.isSetStart()) {
            hashCode += 911 * this.getStart().hashCode();
        }
        if (this.isSetEnd()) {
            hashCode += 911 * this.getEnd().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean isSetEnd() {
        return this.end != null;
    }

    @Override
    public boolean isSetStart() {
        return this.start != null;
    }

    @Override
    public void setEnd(Point end) {
        Point old = this.end;
        if (this.end != null) {
            this.end.fireNodeRemovedEvent();
        }
        this.end = end;
        if (end != null) {
            end.setElementName("end");
        }
        this.registerChild((SBase)this.end);
        this.firePropertyChange("end", (Object)old, (Object)this.end);
    }

    @Override
    public void setStart(Point start) {
        Point old = this.start;
        if (this.start != null) {
            this.start.fireNodeRemovedEvent();
        }
        this.start = start;
        if (start != null) {
            start.setElementName("start");
        }
        this.registerChild((SBase)this.start);
        this.firePropertyChange("start", (Object)old, (Object)this.start);
    }

    @Override
    public void unsetEnd() {
        this.setEnd(null);
    }

    @Override
    public void unsetStart() {
        this.setStart(null);
    }
}

