/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.util.ResourceManager;
import org.sbml.jsbml.util.StringTools;

public class Point
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -7464572763198848890L;
    private static final transient Logger logger = Logger.getLogger(Point.class);
    private Double x;
    private Double y;
    private Double z;
    private String xmlElementName;

    public Point() {
        this.initDefaults();
    }

    public Point(double x, double y) {
        this();
        this.x = x;
        this.y = y;
        this.z = Double.NaN;
    }

    public Point(double x, double y, double z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(double x, double y, double z, int level, int version) {
        this(level, version);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Point(Point point) {
        super((AbstractNamedSBase)point);
        this.clonePointAttributes(point, this);
        this.setElementName(point.getElementName());
    }

    public Point clone() {
        return new Point(this);
    }

    protected void clonePointAttributes(Point point, Point cloned) {
        if (point.isSetX()) {
            cloned.setX(point.getX());
        } else {
            cloned.setX(Double.NaN);
        }
        if (point.isSetY()) {
            cloned.setY(point.getY());
        } else {
            cloned.setY(Double.NaN);
        }
        if (point.isSetZ()) {
            cloned.setZ(point.getZ());
        } else {
            cloned.setZ(Double.NaN);
        }
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
        this.y = this.z = Double.valueOf(Double.NaN);
        this.x = this.z;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            Point p = (Point)((Object)object);
            if ((equals &= p.isSetX() == this.isSetX()) && this.isSetX()) {
                equals &= Double.valueOf(p.getX()).equals(this.getX());
            }
            if ((equals &= p.isSetY() == this.isSetY()) && this.isSetY()) {
                equals &= Double.valueOf(p.getY()).equals(this.getY());
            }
            if ((equals &= p.isSetZ() == this.isSetZ()) && this.isSetZ()) {
                equals &= Double.valueOf(p.getZ()).equals(this.getZ());
            }
        }
        return equals;
    }

    public String getElementName() {
        return this.xmlElementName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int hashCode() {
        int prime = 947;
        int hashCode = super.hashCode();
        hashCode += 947 * Double.valueOf(this.x).hashCode();
        hashCode += 947 * Double.valueOf(this.y).hashCode();
        return hashCode += 947 * Double.valueOf(this.z).hashCode();
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetElementName() {
        return this.xmlElementName != null;
    }

    public boolean isSetX() {
        return this.x != null && !Double.isNaN(this.x);
    }

    public boolean isSetY() {
        return this.y != null && !Double.isNaN(this.y);
    }

    public boolean isSetZ() {
        return this.z != null && !Double.isNaN(this.z);
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("x")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setX(valueDouble);
            } else if (attributeName.equals("y")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setY(valueDouble);
            } else if (attributeName.equals("z")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setZ(valueDouble);
            } else {
                return false;
            }
        }
        return isAttributeRead;
    }

    void setElementName(String elementName) {
        this.xmlElementName = elementName;
    }

    public void setX(double x) {
        Double oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", oldX, this.x);
    }

    public void setY(double y) {
        Double oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", oldY, this.y);
    }

    public void setZ(double z) {
        Double oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", oldZ, this.z);
    }

    void unsetElementName() {
        String oldName = this.xmlElementName;
        this.setElementName(null);
        this.firePropertyChange("name", oldName, this.xmlElementName);
    }

    public void unsetX() {
        Double oldX = this.x;
        this.x = null;
        this.firePropertyChange("x", oldX, this.x);
    }

    public void unsetY() {
        Double oldY = this.y;
        this.y = null;
        this.firePropertyChange("y", oldY, this.y);
    }

    public void unsetZ() {
        Double oldZ = this.z;
        this.z = null;
        this.firePropertyChange("z", oldZ, this.z);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("layout:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            logger.warn((Object)MessageFormat.format(ResourceManager.getBundle((String)"org.sbml.jsbml.resources.cfg.Messages").getString("UNDEFINED_ATTRIBUTE"), "name", this.getLevel(), this.getVersion(), this.getElementName()));
        }
        if (this.isSetX()) {
            attributes.put("layout:x", StringTools.toString((Locale)Locale.ENGLISH, (double)this.x));
        }
        if (this.isSetY()) {
            attributes.put("layout:y", StringTools.toString((Locale)Locale.ENGLISH, (double)this.y));
        }
        if (this.isSetZ()) {
            attributes.put("layout:z", StringTools.toString((Locale)Locale.ENGLISH, (double)this.z));
        }
        return attributes;
    }

    public double x() {
        return this.getX();
    }

    public double y() {
        return this.getY();
    }

    public double z() {
        return this.getZ();
    }
}

