/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class BoundingBoxConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021301, 6021305);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021301: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021302: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021303: {
                func = new ValidationFunction<BoundingBox>(){

                    public boolean check(ValidationContext ctx, BoundingBox boundingBox) {
                        return boundingBox.isSetPosition() && boundingBox.isSetDimensions() && new DuplicatedElementValidationFunction("dimensions").check(ctx, (TreeNodeWithChangeSupport)boundingBox) && new DuplicatedElementValidationFunction("position").check(ctx, (TreeNodeWithChangeSupport)boundingBox) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)boundingBox);
                    }
                };
                break;
            }
            case 6021304: {
                func = new UnknownPackageAttributeValidationFunction("layout");
                break;
            }
            case 6021305: {
                func = new ValidationFunction<BoundingBox>(){

                    public boolean check(ValidationContext ctx, BoundingBox boundingBox) {
                        if (boundingBox.isSetPosition() && boundingBox.isSetDimensions()) {
                            return boundingBox.getPosition().isSetZ() ? true : !boundingBox.getDimensions().isSetDepth();
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

