/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class CurveConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021401, 6021407);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021401: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021402: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021403: {
                func = new ValidationFunction<Curve>(){

                    public boolean check(ValidationContext ctx, Curve curve) {
                        return curve.isSetListOfCurveSegments() && new DuplicatedElementValidationFunction("listOfCurveSegments").check(ctx, (TreeNodeWithChangeSupport)curve) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)curve);
                    }
                };
                break;
            }
            case 6021404: {
                func = new UnknownPackageAttributeValidationFunction("layout");
                break;
            }
            case 6021405: {
                func = new ValidationFunction<Curve>(){

                    public boolean check(ValidationContext ctx, Curve curve) {
                        if (curve.isSetListOfCurveSegments()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, curve.getListOfCurveSegments()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, curve.getListOfCurveSegments());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021406: {
                func = new ValidationFunction<Curve>(){

                    public boolean check(ValidationContext ctx, Curve curve) {
                        if (curve.isSetListOfCurveSegments()) {
                            return new UnknownElementValidationFunction().check(ctx, curve.getListOfCurveSegments());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021407: {
                func = new ValidationFunction<Curve>(){

                    public boolean check(ValidationContext ctx, Curve curve) {
                        if (curve.isSetListOfCurveSegments()) {
                            return curve.getCurveSegmentCount() > 0;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

