/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class GraphicalObjectConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020401, 6020407);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020401: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020402: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020403: {
                func = new ValidationFunction<GraphicalObject>(){

                    public boolean check(ValidationContext ctx, GraphicalObject graphicalObject) {
                        return new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)graphicalObject) && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (TreeNodeWithChangeSupport)graphicalObject);
                    }
                };
                break;
            }
            case 6020404: {
                func = new UnknownPackageAttributeValidationFunction<GraphicalObject>("layout"){

                    public boolean check(ValidationContext ctx, GraphicalObject graphicalObject) {
                        if (!graphicalObject.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)graphicalObject);
                    }
                };
                break;
            }
            case 6020405: {
                func = new ValidationFunction<GraphicalObject>(){

                    public boolean check(ValidationContext ctx, GraphicalObject graphicalObject) {
                        if (graphicalObject.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)graphicalObject.getMetaidRef(), (int)graphicalObject.getLevel(), (int)graphicalObject.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020406: {
                func = new ValidationFunction<GraphicalObject>(){

                    public boolean check(ValidationContext ctx, GraphicalObject graphicalObject) {
                        if (graphicalObject.isSetMetaidRef()) {
                            return graphicalObject.getSBMLDocument().getElementByMetaId(graphicalObject.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020407: {
                func = new ValidationFunction<GraphicalObject>(){

                    public boolean check(ValidationContext ctx, GraphicalObject graphicalObject) {
                        return graphicalObject.isSetBoundingBox() && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (TreeNodeWithChangeSupport)graphicalObject);
                    }
                };
            }
        }
        return func;
    }
}

