/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class LayoutConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020301, 6020317);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020301: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020302: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020303: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        return new DuplicatedElementValidationFunction("listOfCompartmentGlyphs").check(ctx, (TreeNodeWithChangeSupport)layout) && new DuplicatedElementValidationFunction("listOfSpeciesGlyphs").check(ctx, (TreeNodeWithChangeSupport)layout) && new DuplicatedElementValidationFunction("listOfReactionGlyphs").check(ctx, (TreeNodeWithChangeSupport)layout) && new DuplicatedElementValidationFunction("listOfTextGlyphs").check(ctx, (TreeNodeWithChangeSupport)layout) && new DuplicatedElementValidationFunction("listOfAdditionalGraphicalObjects").check(ctx, (TreeNodeWithChangeSupport)layout);
                    }
                };
                break;
            }
            case 6020304: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfCompartmentGlyphs() && layout.getListOfCompartmentGlyphs().size() == 0) {
                            return false;
                        }
                        if (layout.isSetListOfSpeciesGlyphs() && layout.getListOfSpeciesGlyphs().size() == 0) {
                            return false;
                        }
                        if (layout.isSetListOfReactionGlyphs() && layout.getListOfReactionGlyphs().size() == 0) {
                            return false;
                        }
                        if (layout.isSetListOfTextGlyphs() && layout.getListOfTextGlyphs().size() == 0) {
                            return false;
                        }
                        return !layout.isSetListOfAdditionalGraphicalObjects() || layout.getListOfAdditionalGraphicalObjects().size() != 0;
                    }
                };
                break;
            }
            case 6020305: {
                func = new UnknownPackageAttributeValidationFunction<Layout>("layout"){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (!layout.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)layout);
                    }
                };
                break;
            }
            case 6020306: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        return true;
                    }
                };
                break;
            }
            case 6020307: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfCompartmentGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layout.getListOfCompartmentGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layout.getListOfCompartmentGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020308: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfCompartmentGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, layout.getListOfCompartmentGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020309: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfSpeciesGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layout.getListOfSpeciesGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layout.getListOfSpeciesGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020310: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfSpeciesGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, layout.getListOfSpeciesGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020311: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfReactionGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layout.getListOfReactionGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layout.getListOfReactionGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020312: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfReactionGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, layout.getListOfReactionGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020313: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfAdditionalGraphicalObjects()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layout.getListOfAdditionalGraphicalObjects()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layout.getListOfAdditionalGraphicalObjects());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020314: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfAdditionalGraphicalObjects()) {
                            return new UnknownElementValidationFunction().check(ctx, layout.getListOfAdditionalGraphicalObjects());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020315: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (!layout.isSetDimensions()) {
                            return false;
                        }
                        return new DuplicatedElementValidationFunction("dimensions").check(ctx, (TreeNodeWithChangeSupport)layout);
                    }
                };
                break;
            }
            case 6020316: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfTextGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layout.getListOfTextGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layout.getListOfTextGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020317: {
                func = new ValidationFunction<Layout>(){

                    public boolean check(ValidationContext ctx, Layout layout) {
                        if (layout.isSetListOfTextGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, layout.getListOfTextGlyphs());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

