/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.List;
import java.util.Set;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class LayoutModelPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                set.add(10102);
                this.addRangeToSet(set, 6020101, 6020103);
                this.addRangeToSet(set, 6020201, 6020204);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 10102: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin layoutMP) {
                        List wrongCurveSegmentList = layoutMP.filter(new Filter(){

                            public boolean accepts(Object o) {
                                return o instanceof CurveSegment && !((CurveSegment)((Object)o)).isSetType();
                            }
                        });
                        if (wrongCurveSegmentList == null || wrongCurveSegmentList.size() > 0) {
                            // empty if block
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020101: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String required = (String)doc.getSBMLDocumentAttributes().get("layout:required");
                        return required != null;
                    }
                };
                break;
            }
            case 6020102: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String required = (String)doc.getSBMLDocumentAttributes().get("layout:required");
                        try {
                            StringTools.parseSBMLBooleanStrict((String)required);
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020103: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin lm) {
                        SBMLDocument doc = lm.getSBMLDocument();
                        String requiredStr = (String)doc.getSBMLDocumentAttributes().get("layout:required");
                        try {
                            boolean required = StringTools.parseSBMLBooleanStrict((String)requiredStr);
                            return !required;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return true;
                        }
                    }
                };
                break;
            }
            case 6020201: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin layoutMP) {
                        return new DuplicatedElementValidationFunction("layout:listOfLayouts").check(ctx, (TreeNodeWithChangeSupport)layoutMP.getModel()) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)layoutMP.getModel());
                    }
                };
                break;
            }
            case 6020202: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin layoutMP) {
                        return !layoutMP.isSetListOfLayouts() || layoutMP.getListOfLayouts().size() != 0;
                    }
                };
                break;
            }
            case 6020203: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin layoutMP) {
                        if (layoutMP.isSetListOfLayouts()) {
                            return new UnknownElementValidationFunction().check(ctx, layoutMP.getListOfLayouts());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020204: {
                func = new ValidationFunction<LayoutModelPlugin>(){

                    public boolean check(ValidationContext ctx, LayoutModelPlugin layoutMP) {
                        if (layoutMP.isSetListOfLayouts()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, layoutMP.getListOfLayouts()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, layoutMP.getListOfLayouts());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

