/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class LineSegmentConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021501, 6021504);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021501: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021502: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021503: {
                func = new ValidationFunction<LineSegment>(){

                    public boolean check(ValidationContext ctx, LineSegment lineSegment) {
                        return lineSegment.isSetStart() && lineSegment.isSetEnd() && new DuplicatedElementValidationFunction("start").check(ctx, (TreeNodeWithChangeSupport)lineSegment) && new DuplicatedElementValidationFunction("end").check(ctx, (TreeNodeWithChangeSupport)lineSegment) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)lineSegment);
                    }
                };
                break;
            }
            case 6021504: {
                func = new UnknownPackageAttributeValidationFunction("layout");
            }
        }
        return func;
    }
}

