/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class SpeciesGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020601, 6020609);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020601: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020602: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020603: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        return new DuplicatedElementValidationFunction("boundingBox").check(ctx, (TreeNodeWithChangeSupport)speciesGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)speciesGlyph);
                    }
                };
                break;
            }
            case 6020604: {
                func = new UnknownPackageAttributeValidationFunction<SpeciesGlyph>("layout"){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (!speciesGlyph.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)speciesGlyph);
                    }
                };
                break;
            }
            case 6020605: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (speciesGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)speciesGlyph.getMetaidRef(), (int)speciesGlyph.getLevel(), (int)speciesGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020606: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (speciesGlyph.isSetMetaidRef()) {
                            return speciesGlyph.getSBMLDocument().getElementByMetaId(speciesGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020607: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (speciesGlyph.isSetSpecies()) {
                            return SyntaxChecker.isValidId((String)speciesGlyph.getSpecies(), (int)speciesGlyph.getLevel(), (int)speciesGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020608: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (speciesGlyph.isSetSpecies()) {
                            return speciesGlyph.getModel().getSpecies(speciesGlyph.getSpecies()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020609: {
                func = new ValidationFunction<SpeciesGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesGlyph speciesGlyph) {
                        if (speciesGlyph.isSetSpecies() && speciesGlyph.isSetMetaidRef()) {
                            try {
                                Species c = speciesGlyph.getModel().getSpecies(speciesGlyph.getSpecies());
                                Species cFromRef = (Species)speciesGlyph.getSBMLDocument().getElementByMetaId(speciesGlyph.getMetaidRef());
                                if ((c == null || cFromRef == null) && c != cFromRef) {
                                    return false;
                                }
                                if (c == null || cFromRef == null || !c.equals((Object)cFromRef)) {
                                    return false;
                                }
                            }
                            catch (ClassCastException e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

