/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.multi;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.multi.MultiConstants;
import org.sbml.jsbml.ext.multi.Selector;
import org.sbml.jsbml.ext.multi.SpeciesType;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class MultiModel
extends AbstractSBasePlugin {
    private static final long serialVersionUID = -2875299722787282885L;
    ListOf<SpeciesType> listOfSpeciesTypes;
    ListOf<Selector> listOfSelectors;

    public String getElementNamespace() {
        return MultiConstants.getNamespaceURI(this.getLevel(), this.getVersion());
    }

    public String getPackageName() {
        return "Multistate and Multicomponent Species";
    }

    public String getPrefix() {
        return "multi";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    public SBMLDocument getParent() {
        return (SBMLDocument)this.getExtendedSBase().getParent();
    }

    public SBMLDocument getParentSBMLObject() {
        return this.getParent();
    }

    public MultiModel(Model model) {
        super((SBase)model);
    }

    public MultiModel(MultiModel multiModel) {
        super((AbstractSBasePlugin)multiModel);
        if (multiModel == null) {
            return;
        }
        if (multiModel.isSetListOfSelectors()) {
            this.listOfSelectors = multiModel.getListOfSelectors().clone();
        }
        if (multiModel.isSetListOfSpeciesTypes()) {
            this.listOfSpeciesTypes = multiModel.getListOfSpeciesTypes().clone();
        }
    }

    public MultiModel clone() {
        return new MultiModel(this);
    }

    public Model getModel() {
        return (Model)this.extendedSBase;
    }

    public ListOf<SpeciesType> getListOfSpeciesTypes() {
        if (this.listOfSpeciesTypes == null) {
            this.listOfSpeciesTypes = new ListOf();
            this.listOfSpeciesTypes.setNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1");
            this.getModel().registerChild(this.listOfSpeciesTypes);
            this.listOfSpeciesTypes.setSBaseListType(ListOf.Type.other);
        }
        return this.listOfSpeciesTypes;
    }

    public boolean addSpeciesType(SpeciesType speciesType) {
        return this.getListOfSpeciesTypes().add((SBase)speciesType);
    }

    public SpeciesType createSpeciesType() {
        return this.createSpeciesType(null);
    }

    public SpeciesType createSpeciesType(String id) {
        SpeciesType speciesType = new SpeciesType();
        speciesType.setId(id);
        this.addSpeciesType(speciesType);
        return speciesType;
    }

    public SpeciesType getSpeciesType(int i) {
        return (SpeciesType)this.getListOfSpeciesTypes().get(i);
    }

    public SpeciesType getSpeciesType(String id) {
        if (this.isSetListOfSpeciesTypes()) {
            return (SpeciesType)this.listOfSpeciesTypes.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public boolean isSetListOfSpeciesTypes() {
        return this.listOfSpeciesTypes != null && !this.listOfSpeciesTypes.isEmpty();
    }

    public boolean unsetListOfSpeciesTypes() {
        if (this.isSetListOfSpeciesTypes()) {
            this.listOfSpeciesTypes = null;
            return true;
        }
        return false;
    }

    public ListOf<Selector> getListOfSelectors() {
        if (this.listOfSelectors == null) {
            this.listOfSelectors = new ListOf();
            this.listOfSelectors.setNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1");
            this.getModel().registerChild(this.listOfSelectors);
            this.listOfSelectors.setSBaseListType(ListOf.Type.other);
        }
        return this.listOfSelectors;
    }

    public void addSelector(Selector selector) {
        this.getListOfSelectors().add((SBase)selector);
    }

    public Selector createSelector() {
        return this.createSelector(null);
    }

    public Selector createSelector(String id) {
        Selector selector = new Selector();
        selector.setId(id);
        this.addSelector(selector);
        return selector;
    }

    public Selector getSelector(int i) {
        return (Selector)this.getListOfSelectors().get(i);
    }

    public Selector getSelector(String id) {
        if (this.isSetListOfSelectors()) {
            return (Selector)this.listOfSelectors.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public boolean isSetListOfSelectors() {
        return this.listOfSelectors != null && !this.listOfSelectors.isEmpty();
    }

    public boolean unsetListOfSelectors() {
        if (this.isSetListOfSelectors()) {
            this.listOfSelectors = null;
            return true;
        }
        return false;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(childIndex + " < 0");
        }
        int pos = 0;
        if (this.isSetListOfSpeciesTypes()) {
            if (pos == childIndex) {
                return this.getListOfSpeciesTypes();
            }
            ++pos;
        }
        if (this.isSetListOfSelectors()) {
            if (pos == childIndex) {
                return this.getListOfSelectors();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfSpeciesTypes()) {
            ++count;
        }
        if (this.isSetListOfSelectors()) {
            ++count;
        }
        return count;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Map<String, String> writeXMLAttributes() {
        return null;
    }
}

