/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.multi.BindingSiteReference;
import org.sbml.jsbml.ext.multi.Bond;
import org.sbml.jsbml.ext.multi.MultiConstants;
import org.sbml.jsbml.ext.multi.MultiModel;
import org.sbml.jsbml.ext.multi.MultiSpecies;
import org.sbml.jsbml.ext.multi.Selector;
import org.sbml.jsbml.ext.multi.SpeciesType;
import org.sbml.jsbml.ext.multi.SpeciesTypeState;
import org.sbml.jsbml.ext.multi.StateFeature;
import org.sbml.jsbml.ext.multi.StateFeatureInstance;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class MultiParser
extends AbstractReaderWriter
implements PackageParser {
    private Logger logger = Logger.getLogger(MultiParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/multi/version1";
    }

    public String getShortLabel() {
        return "multi";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object treeNode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getListOfSBMLElementsToWrite: " + treeNode.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (treeNode instanceof SBase && ((SBase)treeNode).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((Model)treeNode).getExtension(this.getNamespaceURI());
            if (sbasePlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
                this.logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(treeNode);
        }
        return listOfElementsToWrite;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            MultiModel multiModel = null;
            if (model.getExtension("http://www.sbml.org/sbml/level3/version1/multi/version1") != null) {
                multiModel = (MultiModel)model.getExtension("http://www.sbml.org/sbml/level3/version1/multi/version1");
            } else {
                multiModel = new MultiModel(model);
                model.addExtension("http://www.sbml.org/sbml/level3/version1/multi/version1", (SBasePlugin)multiModel);
            }
            if (elementName.equals("listOfSpeciesTypes")) {
                return multiModel.getListOfSpeciesTypes();
            }
            if (elementName.equals("listOfSelectors")) {
                return multiModel.getListOfSelectors();
            }
        } else if (contextObject instanceof SpeciesType) {
            SpeciesType speciesType = (SpeciesType)((Object)contextObject);
            if (elementName.equals("listOfStateFeatures")) {
                return speciesType.getListOfStateFeatures();
            }
        } else if (contextObject instanceof StateFeature) {
            StateFeature stateFeature = (StateFeature)((Object)contextObject);
            if (elementName.equals("listOfPossibleValues")) {
                return stateFeature.getListOfPossibleValues();
            }
        } else if (contextObject instanceof Selector) {
            Selector selector = (Selector)((Object)contextObject);
            if (elementName.equals("listOfSpeciesTypeStates")) {
                return selector.getListOfSpeciesTypeStates();
            }
            if (elementName.equals("listOfBonds")) {
                return selector.getListOfBonds();
            }
            if (elementName.equals("listOfUnboundBindingSites")) {
                return selector.getListOfUnboundBindingSites();
            }
        } else if (contextObject instanceof SpeciesTypeState) {
            SpeciesTypeState speciesTypeState = (SpeciesTypeState)((Object)contextObject);
            if (elementName.equals("listOfStateFeatureInstances")) {
                return speciesTypeState.getListOfStateFeatureInstances();
            }
            if (elementName.equals("listOfContainedSpeciesTypes")) {
                return speciesTypeState.getListOfContainedSpeciesTypes();
            }
        } else if (contextObject instanceof StateFeatureInstance) {
            StateFeatureInstance stateFeatureInstance = (StateFeatureInstance)((Object)contextObject);
            if (elementName.equals("listOfStateFeatureValues")) {
                return stateFeatureInstance.getListOfStateFeatureValues();
            }
        } else if (contextObject instanceof Bond) {
            Bond bond = (Bond)((Object)contextObject);
            if (elementName.equals("bindingSiteReference")) {
                BindingSiteReference bindingSiteReference = new BindingSiteReference();
                bond.addBindingSiteReference(bindingSiteReference);
                return bindingSiteReference;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            Object newElement = this.createListOfChild(listOf, elementName);
            return newElement;
        }
        return contextObject;
    }

    protected Object createListOfChild(ListOf<?> listOf, String elementName) {
        block14: {
            SBase parentSBase = listOf.getParent();
            if (parentSBase == null) {
                return null;
            }
            if (parentSBase instanceof Model) {
                parentSBase = ((Model)parentSBase).getExtension("http://www.sbml.org/sbml/level3/version1/multi/version1");
            }
            String createMethodName = "create" + elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
            Method createMethod = null;
            if (parentSBase instanceof Selector && elementName.equals("bindingSiteReference")) {
                createMethodName = "createUnboundBindingSite";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method '" + createMethodName + "' will be used"));
            }
            try {
                createMethod = parentSBase.getClass().getMethod(createMethodName, null);
                return createMethod.invoke((Object)parentSBase, (Object[])null);
            }
            catch (SecurityException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' is not accessible on " + parentSBase.getClass().getSimpleName()));
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' does not exist on " + parentSBase.getClass().getSimpleName()));
                }
            }
            catch (IllegalArgumentException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (InvocationTargetException e) {
                if (!this.logger.isDebugEnabled()) break block14;
                this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                this.logger.debug((Object)e.getMessage());
            }
        }
        return null;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("writeElement: " + sbmlElementToWrite.getClass().getSimpleName()));
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/multi/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return MultiConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "multi";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Model) {
                return new MultiModel((Model)sbase);
            }
            if (sbase instanceof Species) {
                return new MultiSpecies((Species)sbase);
            }
            if (sbase instanceof Reaction) {
                // empty if block
            }
        }
        return null;
    }
}

