/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.multi;

import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.CompartmentalizedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.UniqueNamedSBase;

public class CompartmentReference
extends AbstractNamedSBase
implements CompartmentalizedSBase,
UniqueNamedSBase {
    private static final long serialVersionUID = 6455311889725292763L;
    private String compartment;

    public CompartmentReference() {
        this.initDefaults();
    }

    public CompartmentReference(CompartmentReference obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetCompartment()) {
            this.setCompartment(obj.getCompartment());
        }
    }

    public CompartmentReference(int level, int version) {
        this(null, null, level, version);
    }

    public CompartmentReference(String id) {
        super(id);
        this.initDefaults();
    }

    public CompartmentReference(String id, int level, int version) {
        this(id, null, level, version);
    }

    public CompartmentReference(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public CompartmentReference clone() {
        return new CompartmentReference(this);
    }

    public String getCompartment() {
        if (this.isSetCompartment()) {
            return this.compartment;
        }
        return null;
    }

    public Compartment getCompartmentInstance() {
        Model model;
        if (this.isSetCompartment() && (model = this.getModel()) != null) {
            return model.getCompartment(this.getCompartment());
        }
        return null;
    }

    public void initDefaults() {
        this.packageName = "multi";
        this.setPackageVersion(-1);
    }

    public boolean isCompartmentMandatory() {
        return true;
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetCompartment() {
        return this.compartment != null;
    }

    public boolean isSetCompartmentInstance() {
        return this.getCompartmentInstance() != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("compartment")) {
                this.setCompartment(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public boolean setCompartment(Compartment compartment) {
        return this.setCompartment(compartment.getId());
    }

    public boolean setCompartment(String compartment) {
        if (compartment != this.compartment) {
            String oldCompartment = this.compartment;
            this.compartment = compartment;
            this.firePropertyChange("compartment", oldCompartment, this.compartment);
            return true;
        }
        return false;
    }

    public boolean unsetCompartment() {
        return this.setCompartment((String)null);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("multi:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("multi:name", this.getName());
        }
        if (this.isSetCompartment()) {
            attributes.put("multi:compartment", this.getCompartment());
        }
        return attributes;
    }
}

