/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.JSBML;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.multi.IntraSpeciesReaction;
import org.sbml.jsbml.ext.multi.MultiASTNodePlugin;
import org.sbml.jsbml.ext.multi.MultiCompartmentPlugin;
import org.sbml.jsbml.ext.multi.MultiConstants;
import org.sbml.jsbml.ext.multi.MultiModelPlugin;
import org.sbml.jsbml.ext.multi.MultiSimpleSpeciesReferencePlugin;
import org.sbml.jsbml.ext.multi.MultiSpeciesPlugin;
import org.sbml.jsbml.ext.multi.MultiSpeciesReferencePlugin;
import org.sbml.jsbml.ext.multi.SpeciesFeature;
import org.sbml.jsbml.ext.multi.SpeciesFeatureType;
import org.sbml.jsbml.ext.multi.SpeciesType;
import org.sbml.jsbml.ext.multi.SpeciesTypeComponentMapInProduct;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class MultiParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(MultiParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/multi/version1";
    }

    public String getShortLabel() {
        return "multi";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object treeNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + treeNode.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (treeNode instanceof SBase && ((SBase)treeNode).getExtension("multi") != null) {
            SBasePlugin sbasePlugin = ((Model)treeNode).getExtension("multi");
            if (sbasePlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
                logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(treeNode);
        }
        if (treeNode instanceof IntraSpeciesReaction) {
            String sbmlNamespace = JSBML.getNamespaceFrom((int)((IntraSpeciesReaction)((Object)treeNode)).getLevel(), (int)((IntraSpeciesReaction)((Object)treeNode)).getVersion());
            for (Object child : listOfElementsToWrite) {
                if (!(child instanceof AbstractSBase) || ((AbstractSBase)child).getNamespace() != null) continue;
                AbstractSBase sbase = (AbstractSBase)child;
                logger.debug((Object)("Found one suspect Model child: " + sbase.getElementName() + ". Setting the SBML namespace to it."));
                sbase.setNamespace(sbmlNamespace);
            }
        }
        return listOfElementsToWrite;
    }

    public boolean processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (contextObject instanceof SBase && ((SBase)contextObject).getPackageName().equals("core")) {
            if (!(contextObject instanceof SBMLDocument)) {
                contextObject = ((SBase)contextObject).getPlugin(this.getShortLabel());
            }
        } else if (contextObject instanceof ASTNode) {
            contextObject = ((ASTNode)contextObject).getPlugin(this.getShortLabel());
        }
        return super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            MultiModelPlugin multiModel = (MultiModelPlugin)model.getPlugin("multi");
            if (elementName.equals("listOfSpeciesTypes")) {
                return multiModel.getListOfSpeciesTypes();
            }
        } else if (contextObject instanceof Compartment) {
            Compartment compartment = (Compartment)contextObject;
            MultiCompartmentPlugin multiCompartment = (MultiCompartmentPlugin)compartment.getPlugin("multi");
            if (elementName.equals("listOfCompartmentReferences")) {
                return multiCompartment.getListOfCompartmentReferences();
            }
        } else if (contextObject instanceof SpeciesType) {
            SpeciesType speciesType = (SpeciesType)((Object)contextObject);
            if (elementName.equals("listOfSpeciesFeatureTypes")) {
                return speciesType.getListOfSpeciesFeatureTypes();
            }
            if (elementName.equals("listOfSpeciesTypeInstances")) {
                return speciesType.getListOfSpeciesTypeInstances();
            }
            if (elementName.equals("listOfSpeciesTypeComponentIndexes")) {
                return speciesType.getListOfSpeciesTypeComponentIndexes();
            }
            if (elementName.equals("listOfInSpeciesTypeBonds")) {
                return speciesType.getListOfInSpeciesTypeBonds();
            }
        } else if (contextObject instanceof SpeciesFeatureType) {
            SpeciesFeatureType speciesFeatureType = (SpeciesFeatureType)((Object)contextObject);
            if (elementName.equals("listOfPossibleSpeciesFeatureValues")) {
                return speciesFeatureType.getListOfPossibleSpeciesFeatureValues();
            }
        } else if (contextObject instanceof Species) {
            Species species = (Species)contextObject;
            MultiSpeciesPlugin multiSpecies = (MultiSpeciesPlugin)species.getPlugin("multi");
            if (elementName.equals("listOfOutwardBindingSites")) {
                return multiSpecies.getListOfOutwardBindingSites();
            }
            if (elementName.equals("listOfSpeciesFeatures")) {
                return multiSpecies.getListOfSpeciesFeatures();
            }
        } else if (contextObject instanceof SpeciesFeature) {
            SpeciesFeature speciesFeature = (SpeciesFeature)((Object)contextObject);
            if (elementName.equals("listOfSpeciesFeatureValues")) {
                return speciesFeature.getListOfSpeciesFeatureValues();
            }
        } else if (contextObject instanceof SpeciesReference) {
            SpeciesReference speciesReference = (SpeciesReference)contextObject;
            MultiSpeciesReferencePlugin multiSpeciesReference = (MultiSpeciesReferencePlugin)speciesReference.getPlugin("multi");
            if (elementName.equals("listOfSpeciesTypeComponentMapInProducts")) {
                return multiSpeciesReference.getListOfSpeciesTypeComponentMapInProducts();
            }
        } else if (contextObject instanceof SpeciesTypeComponentMapInProduct) {
            SpeciesTypeComponentMapInProduct speciesTypeComponentMapInProduct = (SpeciesTypeComponentMapInProduct)((Object)contextObject);
            if (elementName.equals("listOfSpeciesFeatureChanges")) {
                return speciesTypeComponentMapInProduct.getListOfSpeciesFeatureChanges();
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            Object newElement = this.createListOfChild(listOf, elementName);
            return newElement;
        }
        return contextObject;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (xmlObject.isSetName() && xmlObject.getName().equals("listOfBindingSiteSpeciesTypes")) {
            xmlObject.setName("listOfSpeciesTypes");
        } else if (xmlObject.isSetName() && xmlObject.getName().equals("listOfSpeciesTypeComponentIndexs")) {
            xmlObject.setName("listOfSpeciesTypeComponentIndexes");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("writeElement: " + sbmlElementToWrite.getClass().getSimpleName()));
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/multi/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return MultiConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "multi";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Model) {
                return new MultiModelPlugin((Model)sbase);
            }
            if (sbase instanceof Species) {
                return new MultiSpeciesPlugin((Species)sbase);
            }
            if (sbase instanceof Compartment) {
                return new MultiCompartmentPlugin((Compartment)sbase);
            }
            if (sbase instanceof SpeciesReference) {
                return new MultiSpeciesReferencePlugin((SpeciesReference)sbase);
            }
            if (sbase instanceof SimpleSpeciesReference) {
                return new MultiSimpleSpeciesReferencePlugin((SimpleSpeciesReference)sbase);
            }
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        if (astNode != null) {
            return new MultiASTNodePlugin(astNode);
        }
        return null;
    }
}

