/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.MultiCompartmentPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class MultiCompartmentPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020201, 7020203);
                this.addRangeToSet(set, 7020205, 7020209);
                set.add(7020305);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName) {
        attributeName.getClass();
    }

    public ValidationFunction<MultiCompartmentPlugin> getValidationFunction(int errorCode) {
        Object func = null;
        switch (errorCode) {
            case 7020201: {
                func = new UnknownAttributeValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (!c.isSetIsType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)c);
                    }
                };
                break;
            }
            case 7020202: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (!c.isSetIsType()) {
                            // empty if block
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020203: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        return c.isSetIsType();
                    }
                };
                break;
            }
            case 7020205: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (c.isSetIsType() && c.isType()) {
                            return !c.isSetCompartmentType();
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020206: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        DuplicatedElementValidationFunction f = new DuplicatedElementValidationFunction("listOfCompartmentReferences");
                        return f.check(ctx, (Object)c.getParent());
                    }
                };
                break;
            }
            case 7020207: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (c.isSetListOfCompartmentReferences()) {
                            return c.getCompartmentReferenceCount() > 0;
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020208: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (c.isSetListOfCompartmentReferences()) {
                            UnknownAttributeValidationFunction unknownFunc = new UnknownAttributeValidationFunction();
                            return unknownFunc.check(ctx, c.getListOfCompartmentReferences());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020209: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (c.isSetListOfCompartmentReferences()) {
                            UnknownElementValidationFunction unknownFunc = new UnknownElementValidationFunction();
                            return unknownFunc.check(ctx, c.getListOfCompartmentReferences());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020305: {
                func = new ValidationFunction<MultiCompartmentPlugin>(){

                    public boolean check(ValidationContext ctx, MultiCompartmentPlugin c) {
                        if (c.isSetListOfCompartmentReferences()) {
                            // empty if block
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

