/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.multi.CompartmentReference;
import org.sbml.jsbml.ext.multi.MultiCompartmentPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class CompartmentReferenceConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                set.add(7020204);
                this.addRangeToSet(set, 7020301, 7020304);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
        attributeName.getClass();
    }

    public ValidationFunction<CompartmentReference> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020204: {
                func = new ValidationFunction<CompartmentReference>(){

                    public boolean check(ValidationContext ctx, CompartmentReference cr) {
                        boolean valid;
                        Compartment c_ref = cr.getCompartmentInstance();
                        MultiCompartmentPlugin c_refp = c_ref != null ? (MultiCompartmentPlugin)c_ref.getPlugin("multi") : null;
                        MultiCompartmentPlugin c_parent = (MultiCompartmentPlugin)((SBase)cr.getParent().getParent()).getPlugin("multi");
                        if (c_refp == null) {
                            return true;
                        }
                        boolean bl = valid = c_refp.isSetIsType() == c_parent.isSetIsType();
                        if (valid && c_refp.isSetIsType()) {
                            valid = c_refp.isType() == c_parent.isType();
                        }
                        return valid;
                    }
                };
                break;
            }
            case 7020301: {
                func = new UnknownAttributeValidationFunction();
                break;
            }
            case 7020302: {
                func = new UnknownElementValidationFunction();
                break;
            }
            case 7020303: {
                func = new UnknownAttributeValidationFunction<CompartmentReference>(){

                    public boolean check(ValidationContext ctx, CompartmentReference cr) {
                        if (!cr.isSetCompartment()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)cr);
                    }
                };
                break;
            }
            case 7020304: {
                func = new ValidationFunction<CompartmentReference>(){

                    public boolean check(ValidationContext ctx, CompartmentReference cr) {
                        if (cr.isSetCompartment()) {
                            return cr.getCompartmentInstance() != null;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

