/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.InSpeciesTypeBond;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class InSpeciesTypeBondConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7021101, 7021106);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<InSpeciesTypeBond> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7021101: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7021102: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7021103: {
                func = new ValidationFunction<InSpeciesTypeBond>(){

                    public boolean check(ValidationContext ctx, InSpeciesTypeBond istb) {
                        if (!istb.isSetBindingSite1() || !istb.isSetBindingSite2()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("multi").check(ctx, (TreeNodeWithChangeSupport)istb);
                    }
                };
                break;
            }
            case 7021104: {
                func = new ValidationFunction<InSpeciesTypeBond>(){

                    public boolean check(ValidationContext ctx, InSpeciesTypeBond istb) {
                        return true;
                    }
                };
                break;
            }
            case 7021105: {
                func = new ValidationFunction<InSpeciesTypeBond>(){

                    public boolean check(ValidationContext ctx, InSpeciesTypeBond istb) {
                        return true;
                    }
                };
                break;
            }
            case 7021106: {
                func = new ValidationFunction<InSpeciesTypeBond>(){

                    public boolean check(ValidationContext ctx, InSpeciesTypeBond istb) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

