/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.PossibleSpeciesFeatureValue;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class PossibleSpeciesFeatureValueConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020701, 7020704);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<PossibleSpeciesFeatureValue> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020701: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7020702: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7020703: {
                func = new ValidationFunction<PossibleSpeciesFeatureValue>(){

                    public boolean check(ValidationContext ctx, PossibleSpeciesFeatureValue psfv) {
                        if (!psfv.isSetId()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("multi").check(ctx, (TreeNodeWithChangeSupport)psfv);
                    }
                };
                break;
            }
            case 7020704: {
                func = new ValidationFunction<PossibleSpeciesFeatureValue>(){

                    public boolean check(ValidationContext ctx, PossibleSpeciesFeatureValue psfv) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

