/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.SpeciesFeatureType;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpeciesFeatureTypeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020601, 7020608);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<SpeciesFeatureType> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7020602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7020603: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        if (!sft.isSetId() || !sft.isSetOccur()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("multi").check(ctx, (TreeNodeWithChangeSupport)sft);
                    }
                };
                break;
            }
            case 7020604: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        return true;
                    }
                };
                break;
            }
            case 7020605: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        return true;
                    }
                };
                break;
            }
            case 7020606: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        if (sft.isSetListOfPossibleSpeciesFeatureValues()) {
                            return new UnknownAttributeValidationFunction().check(ctx, sft.getListOfPossibleSpeciesFeatureValues());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020607: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        if (sft.isSetListOfPossibleSpeciesFeatureValues()) {
                            return new UnknownElementValidationFunction().check(ctx, sft.getListOfPossibleSpeciesFeatureValues());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020608: {
                func = new ValidationFunction<SpeciesFeatureType>(){

                    public boolean check(ValidationContext ctx, SpeciesFeatureType sft) {
                        if (sft.isSetListOfPossibleSpeciesFeatureValues()) {
                            return sft.getPossibleSpeciesFeatureValueCount() > 0;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

