/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.SpeciesTypeComponentIndex;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpeciesTypeComponentIndexConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020901, 7020907);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<SpeciesTypeComponentIndex> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7020902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7020903: {
                func = new ValidationFunction<SpeciesTypeComponentIndex>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeComponentIndex stci) {
                        if (!stci.isSetId() || !stci.isSetComponent()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("multi").check(ctx, (TreeNodeWithChangeSupport)stci);
                    }
                };
                break;
            }
            case 7020904: {
                func = new ValidationFunction<SpeciesTypeComponentIndex>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeComponentIndex stci) {
                        return true;
                    }
                };
                break;
            }
            case 7020907: {
                func = new ValidationFunction<SpeciesTypeComponentIndex>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeComponentIndex stci) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

