/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.BindingSiteSpeciesType;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;

public class BindingSiteSpeciesTypeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                set.add(7020501);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<BindingSiteSpeciesType> getValidationFunction(int errorCode, ValidationContext context) {
        ValidationFunction<BindingSiteSpeciesType> func = null;
        switch (errorCode) {
            case 7020501: {
                func = new ValidationFunction<BindingSiteSpeciesType>(){

                    public boolean check(ValidationContext ctx, BindingSiteSpeciesType bsSt) {
                        return !bsSt.isSetListOfSpeciesTypeInstances() || bsSt.getSpeciesTypeInstanceCount() <= 0;
                    }
                };
            }
        }
        return func;
    }
}

