/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.MultiModelPlugin;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class MultiModelPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020101, 7020103);
                this.addRangeToSet(set, 7020201, 7020204);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<MultiModelPlugin> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020201: {
                func = new DuplicatedElementValidationFunction("listOfSpeciesTypes");
                break;
            }
            case 7020202: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        if (multiM.isSetListOfSpeciesTypes()) {
                            return multiM.getListOfSpeciesTypes().size() > 0;
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020203: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        return true;
                    }
                };
                break;
            }
            case 7020204: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        return new UnknownElementValidationFunction().check(ctx, multiM.getListOfSpeciesTypes());
                    }
                };
                break;
            }
            case 7020101: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        return true;
                    }
                };
                break;
            }
            case 7020102: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        return true;
                    }
                };
                break;
            }
            case 7020103: {
                func = new ValidationFunction<MultiModelPlugin>(){

                    public boolean check(ValidationContext ctx, MultiModelPlugin multiM) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

