/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.multi.MultiSpeciesType;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class MultiSpeciesTypeConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020401, 7020417);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<MultiSpeciesType> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020401: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7020402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7020403: {
                func = new UnknownPackageAttributeValidationFunction("multi");
                break;
            }
            case 7020404: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        Model m;
                        return !st.isSetCompartment() || (m = st.getModel()) == null || m.getCompartment(st.getCompartment()) != null;
                    }
                };
                break;
            }
            case 7020405: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        boolean isValid = true;
                        if (st.isSetListOfSpeciesFeatureTypes()) {
                            boolean bl = isValid = st.getSpeciesFeatureTypeCount() > 0;
                        }
                        if (st.isSetListOfSpeciesTypeInstances()) {
                            isValid &= st.getSpeciesTypeInstanceCount() > 0;
                        }
                        if (st.isSetListOfSpeciesTypeComponentIndexes()) {
                            isValid &= st.getSpeciesTypeComponentIndexCount() > 0;
                        }
                        if (st.isSetListOfInSpeciesTypeBonds()) {
                            isValid &= st.getInSpeciesTypeBondCount() > 0;
                        }
                        return isValid;
                    }
                };
                break;
            }
            case 7020406: {
                func = new DuplicatedElementValidationFunction("listOfSpeciesFeatures");
                break;
            }
            case 7020407: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesFeatureTypes()) {
                            return new UnknownElementValidationFunction().check(ctx, st.getListOfSpeciesFeatureTypes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020408: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesFeatureTypes()) {
                            return new UnknownAttributeValidationFunction().check(ctx, st.getListOfSpeciesFeatureTypes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020409: {
                func = new DuplicatedElementValidationFunction("listOfSpeciesTypeInstances");
                break;
            }
            case 7020410: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesTypeInstances()) {
                            return new UnknownElementValidationFunction().check(ctx, st.getListOfSpeciesTypeInstances());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020411: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesTypeInstances()) {
                            return new UnknownAttributeValidationFunction().check(ctx, st.getListOfSpeciesTypeInstances());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020412: {
                func = new DuplicatedElementValidationFunction("listOfSpeciesTypeComponentIndexes");
                break;
            }
            case 7020413: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesTypeComponentIndexes()) {
                            return new UnknownElementValidationFunction().check(ctx, st.getListOfSpeciesTypeComponentIndexes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020414: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfSpeciesTypeComponentIndexes()) {
                            return new UnknownAttributeValidationFunction().check(ctx, st.getListOfSpeciesTypeComponentIndexes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020415: {
                func = new DuplicatedElementValidationFunction("listOfInSpeciesTypeBonds");
                break;
            }
            case 7020416: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfInSpeciesTypeBonds()) {
                            return new UnknownElementValidationFunction().check(ctx, st.getListOfInSpeciesTypeBonds());
                        }
                        return true;
                    }
                };
                break;
            }
            case 7020417: {
                func = new ValidationFunction<MultiSpeciesType>(){

                    public boolean check(ValidationContext ctx, MultiSpeciesType st) {
                        if (st.isSetListOfInSpeciesTypeBonds()) {
                            return new UnknownAttributeValidationFunction().check(ctx, st.getListOfInSpeciesTypeBonds());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

