/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.multi.SpeciesTypeInstance;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpeciesTypeInstanceConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 7020801, 7020806);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<SpeciesTypeInstance> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 7020801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 7020802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 7020803: {
                func = new ValidationFunction<SpeciesTypeInstance>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeInstance sti) {
                        if (!sti.isSetId() || !sti.isSetSpeciesType()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("multi").check(ctx, (TreeNodeWithChangeSupport)sti);
                    }
                };
                break;
            }
            case 7020805: {
                func = new ValidationFunction<SpeciesTypeInstance>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeInstance sti) {
                        return true;
                    }
                };
                break;
            }
            case 7020806: {
                func = new ValidationFunction<SpeciesTypeInstance>(){

                    public boolean check(ValidationContext ctx, SpeciesTypeInstance sti) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

