/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.qual;

import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.qual.InputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Sign;
import org.sbml.jsbml.util.StringTools;

public class Input
extends AbstractNamedSBase
implements UniqueNamedSBase,
CallableSBase {
    private static final long serialVersionUID = -3370025650545068132L;
    private String qualitativeSpecies;
    private InputTransitionEffect transitionEffect;
    private Integer thresholdLevel;
    private Sign sign;

    public Input() {
        this.initDefaults();
    }

    public Input(String id) {
        super(id);
        this.initDefaults();
    }

    public Input(String id, QualitativeSpecies qualitativeSpecies, InputTransitionEffect transitionEffect) {
        this(id);
        this.setQualitativeSpecies(qualitativeSpecies.getId());
        this.setTransitionEffect(transitionEffect);
    }

    public Input(int level, int version) {
        this(null, null, level, version);
    }

    public Input(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Input(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public Input(Input in) {
        super((AbstractNamedSBase)in);
        if (in.isSetQualitativeSpecies()) {
            this.setQualitativeSpecies(in.getQualitativeSpecies());
        }
        if (in.isSetSign()) {
            this.setSign(in.getSign());
        }
        if (in.isSetThresholdLevel()) {
            this.setThresholdLevel(in.getThresholdLevel());
        }
        if (in.isSetTransitionEffect()) {
            this.setTransitionEffect(in.getTransitionEffect());
        }
    }

    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/qual/version1");
        this.qualitativeSpecies = null;
        this.transitionEffect = null;
        this.thresholdLevel = null;
        this.sign = null;
    }

    public AbstractSBase clone() {
        return new Input(this);
    }

    public void setSign(Sign sign) {
        Sign oldSign = this.sign;
        this.sign = sign;
        this.firePropertyChange("sign", (Object)oldSign, (Object)this.sign);
    }

    public boolean isSetSign() {
        return this.sign != null;
    }

    public Sign getSign() {
        if (this.isSetSign()) {
            return this.sign;
        }
        throw new PropertyUndefinedError("sign", (SBase)this);
    }

    public boolean unsetSign() {
        if (this.isSetSign()) {
            this.setSign(null);
            return true;
        }
        return false;
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isQualitativeSpeciesMandatory() {
        return true;
    }

    public boolean isSetQualitativeSpecies() {
        return this.qualitativeSpecies != null;
    }

    public String getQualitativeSpecies() {
        if (this.isSetQualitativeSpecies()) {
            return this.qualitativeSpecies;
        }
        throw new PropertyUndefinedError("qualitativeSpecies", (SBase)this);
    }

    public void setQualitativeSpecies(String qualitativeSpecies) {
        String oldQualitativeSpecies = this.qualitativeSpecies;
        this.qualitativeSpecies = qualitativeSpecies;
        this.firePropertyChange("qualitativeSpecies", oldQualitativeSpecies, this.qualitativeSpecies);
    }

    public boolean unsetQualitativeSpecies() {
        if (this.qualitativeSpecies != null) {
            this.setQualitativeSpecies(null);
            return true;
        }
        return false;
    }

    public boolean isTransitionEffectMandatory() {
        return false;
    }

    public boolean isSetTransitionEffect() {
        return this.transitionEffect != null;
    }

    public InputTransitionEffect getTransitionEffect() {
        if (this.isSetTransitionEffect()) {
            return this.transitionEffect;
        }
        throw new PropertyUndefinedError("transitionEffect", (SBase)this);
    }

    public void setTransitionEffect(InputTransitionEffect transitionEffect) {
        InputTransitionEffect oldTransitionEffect = this.transitionEffect;
        this.transitionEffect = transitionEffect;
        this.firePropertyChange("transitionEffect", (Object)oldTransitionEffect, (Object)this.transitionEffect);
    }

    public boolean unsetTransitionEffect() {
        if (this.isSetTransitionEffect()) {
            this.setTransitionEffect(null);
            return true;
        }
        return false;
    }

    public boolean isThresholdLevelMandatory() {
        return false;
    }

    public boolean isSetThresholdLevel() {
        return this.thresholdLevel != null;
    }

    public int getThresholdLevel() {
        if (this.isSetThresholdLevel()) {
            return this.thresholdLevel;
        }
        throw new PropertyUndefinedError("thresholdLevel", (SBase)this);
    }

    public void setThresholdLevel(int thresholdLevel) {
        Integer oldThresholdLevel = this.thresholdLevel;
        this.thresholdLevel = thresholdLevel;
        this.firePropertyChange("thresholdLevel", oldThresholdLevel, this.thresholdLevel);
    }

    public boolean unsetThresholdLevel() {
        if (this.isSetThresholdLevel()) {
            Integer oldThresholdLevel = this.thresholdLevel;
            this.thresholdLevel = null;
            this.firePropertyChange("thresholdLevel", oldThresholdLevel, this.thresholdLevel);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            Input i = (Input)((Object)object);
            if ((equals &= i.isSetQualitativeSpecies() == this.isSetQualitativeSpecies()) && this.isSetQualitativeSpecies()) {
                equals &= i.getQualitativeSpecies().equals(this.getQualitativeSpecies());
            }
            if ((equals &= i.isSetTransitionEffect() == this.isSetTransitionEffect()) && this.isSetTransitionEffect()) {
                equals &= i.getTransitionEffect().equals((Object)this.getTransitionEffect());
            }
            if ((equals &= i.isSetThresholdLevel() == this.isSetThresholdLevel()) && this.isSetThresholdLevel()) {
                equals &= i.getThresholdLevel() == this.getThresholdLevel();
            }
            if ((equals &= i.isSetSign() == this.isSetSign()) && this.isSetSign()) {
                equals &= i.getSign() == this.getSign();
            }
        }
        return equals;
    }

    public int hashCode() {
        int prime = 491;
        int hashCode = super.hashCode();
        if (this.isSetQualitativeSpecies()) {
            hashCode += 491 * this.getQualitativeSpecies().hashCode();
        }
        if (this.isSetTransitionEffect()) {
            hashCode += 491 * this.getTransitionEffect().hashCode();
        }
        if (this.isSetThresholdLevel()) {
            hashCode += 491 * this.getThresholdLevel();
        }
        if (this.isSetSign()) {
            hashCode += 491 * this.getSign().hashCode();
        }
        return hashCode;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("qualitativeSpecies")) {
                this.setQualitativeSpecies(value);
            } else if (attributeName.equals("thresholdLevel")) {
                this.setThresholdLevel(StringTools.parseSBMLInt((String)value));
            } else if (attributeName.equals("sign")) {
                try {
                    this.setSign(Sign.valueOf(value));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "sign" + " on the 'input' element.");
                }
            } else if (attributeName.equals("transitionEffect")) {
                try {
                    this.setTransitionEffect(InputTransitionEffect.valueOf(value));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "transitionEffect" + " on the 'input' element.");
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("qual:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("qual:name", this.getName());
        }
        if (this.isSetQualitativeSpecies()) {
            attributes.put("qual:qualitativeSpecies", this.getQualitativeSpecies());
        }
        if (this.isSetThresholdLevel()) {
            attributes.put("qual:thresholdLevel", Integer.toString(this.getThresholdLevel()));
        }
        if (this.isSetTransitionEffect()) {
            attributes.put("qual:transitionEffect", this.getTransitionEffect().toString());
        }
        if (this.isSetSign()) {
            attributes.put("qual:sign", this.getSign().toString());
        }
        return attributes;
    }

    public boolean containsUndeclaredUnits() {
        return false;
    }

    public UnitDefinition getDerivedUnitDefinition() {
        return null;
    }

    public String getDerivedUnits() {
        return null;
    }
}

