/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.qual;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class QualModelPlugin
extends AbstractSBasePlugin {
    private static final long serialVersionUID = 1861588578911387944L;
    private ListOf<QualitativeSpecies> listOfQualitativeSpecies;
    private ListOf<Transition> listOfTransitions;

    public String getPackageName() {
        return "qual";
    }

    public String getPrefix() {
        return "qual";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    public SBMLDocument getParent() {
        if (this.isSetExtendedSBase()) {
            return (SBMLDocument)this.getExtendedSBase().getParent();
        }
        return null;
    }

    public SBMLDocument getParentSBMLObject() {
        return this.getParent();
    }

    public QualModelPlugin(Model model) {
        super((SBase)model);
    }

    public QualModelPlugin(QualModelPlugin qualitativeModel) {
        super((SBasePlugin)qualitativeModel);
        if (qualitativeModel.isSetListOfQualitativeSpecies()) {
            this.setListOfQualitativeSpecies((ListOf<QualitativeSpecies>)qualitativeModel.getListOfQualitativeSpecies().clone());
        }
        if (qualitativeModel.isSetListOfTransitions()) {
            this.setListOfTransitions((ListOf<Transition>)qualitativeModel.getListOfTransitions().clone());
        }
    }

    public void addQualitativeSpecies(QualitativeSpecies qualitativeSpecies) {
        this.getListOfQualitativeSpecies().add((SBase)qualitativeSpecies);
    }

    public void addTransition(Transition transition) {
        this.getListOfTransitions().add((SBase)transition);
    }

    public QualModelPlugin clone() {
        return new QualModelPlugin(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfQualitativeSpecies()) {
            if (pos == childIndex) {
                return this.getListOfQualitativeSpecies();
            }
            ++pos;
        }
        if (this.isSetListOfTransitions()) {
            if (pos == childIndex) {
                return this.getListOfTransitions();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfQualitativeSpecies()) {
            ++count;
        }
        if (this.isSetListOfTransitions()) {
            ++count;
        }
        return count;
    }

    public Transition createTransition() {
        return this.createTransition(null);
    }

    public Transition createTransition(String id) {
        Transition transition = new Transition(id);
        this.addTransition(transition);
        return transition;
    }

    public Transition createTransition(String id, Input in, Output out) {
        Transition transition = this.createTransition(id);
        transition.addInput(in);
        transition.addOutput(out);
        return transition;
    }

    public QualitativeSpecies createQualitativeSpecies() {
        return this.createQualitativeSpecies(null);
    }

    public QualitativeSpecies createQualitativeSpecies(String id) {
        QualitativeSpecies species = new QualitativeSpecies(id);
        this.addSpecies(species);
        return species;
    }

    public QualitativeSpecies createQualitativeSpecies(String id, String compartment, boolean constant) {
        QualitativeSpecies species = new QualitativeSpecies(id);
        species.setCompartment(compartment);
        species.setConstant(constant);
        this.addSpecies(species);
        return species;
    }

    public QualitativeSpecies createQualitativeSpecies(String id, Compartment compartment, boolean constant) {
        return this.createQualitativeSpecies(id, compartment.getId(), constant);
    }

    public QualitativeSpecies createQualitativeSpecies(String id, String metaId, Species species) {
        QualitativeSpecies qualSpecies = new QualitativeSpecies(species);
        qualSpecies.setId(id);
        qualSpecies.setMetaId(metaId);
        this.addSpecies(qualSpecies);
        return qualSpecies;
    }

    public boolean addSpecies(QualitativeSpecies spec) {
        return this.getListOfQualitativeSpecies().add((SBase)spec);
    }

    public QualitativeSpecies createQualitativeSpecies(String id, Compartment c) {
        QualitativeSpecies s = this.createQualitativeSpecies(id);
        s.setCompartment(c);
        return s;
    }

    public ListOf<QualitativeSpecies> getListOfQualitativeSpecies() {
        if (!this.isSetListOfQualitativeSpecies()) {
            this.listOfQualitativeSpecies = new ListOf();
            this.listOfQualitativeSpecies.setPackageVersion(-1);
            this.listOfQualitativeSpecies.setPackageName(null);
            this.listOfQualitativeSpecies.setPackageName("qual");
            this.listOfQualitativeSpecies.setSBaseListType(ListOf.Type.other);
            if (this.isSetExtendedSBase()) {
                this.getModel().registerChild(this.listOfQualitativeSpecies);
            }
        }
        return this.listOfQualitativeSpecies;
    }

    public ListOf<Transition> getListOfTransitions() {
        if (!this.isSetListOfTransitions()) {
            this.listOfTransitions = new ListOf();
            this.listOfTransitions.setPackageVersion(-1);
            this.listOfTransitions.setPackageName(null);
            this.listOfTransitions.setPackageName("qual");
            this.listOfTransitions.setSBaseListType(ListOf.Type.other);
            if (this.isSetExtendedSBase()) {
                this.getModel().registerChild(this.listOfTransitions);
            }
        }
        return this.listOfTransitions;
    }

    public boolean removeTransition(Transition transition) {
        if (this.isSetListOfTransitions()) {
            return this.listOfTransitions.remove((NamedSBase)transition);
        }
        return false;
    }

    public boolean removeQualitativeSpecies(QualitativeSpecies qualitativeSpecies) {
        if (this.isSetListOfQualitativeSpecies()) {
            return this.listOfQualitativeSpecies.remove((NamedSBase)qualitativeSpecies);
        }
        return false;
    }

    public Model getModel() {
        if (this.isSetExtendedSBase()) {
            return (Model)this.extendedSBase;
        }
        return null;
    }

    public int getNumQualitativeSpecies() {
        return this.getQualitativeSpeciesCount();
    }

    public int getNumTransitions() {
        return this.getTransitionCount();
    }

    public QualitativeSpecies getQualitativeSpecies(int i) {
        return (QualitativeSpecies)this.getListOfQualitativeSpecies().get(i);
    }

    public QualitativeSpecies getQualitativeSpecies(String id) {
        if (this.isSetListOfQualitativeSpecies()) {
            return (QualitativeSpecies)this.listOfQualitativeSpecies.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getQualitativeSpeciesCount() {
        if (!this.isSetListOfQualitativeSpecies()) {
            return 0;
        }
        return this.getListOfQualitativeSpecies().size();
    }

    public boolean containsQualitativeSpecies(QualitativeSpecies qs) {
        return this.isSetListOfQualitativeSpecies() && this.listOfQualitativeSpecies.contains((Object)qs);
    }

    public Transition getTransition(int i) {
        return (Transition)this.getListOfTransitions().get(i);
    }

    public Transition getTransition(String id) {
        if (this.isSetListOfTransitions()) {
            Model m = this.getModel();
            if (m != null) {
                return (Transition)m.findNamedSBase(id);
            }
            return (Transition)this.listOfTransitions.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getTransitionCount() {
        if (!this.isSetListOfTransitions()) {
            return 0;
        }
        return this.getListOfTransitions().size();
    }

    public boolean isSetListOfQualitativeSpecies() {
        return this.listOfQualitativeSpecies != null && !this.listOfQualitativeSpecies.isEmpty();
    }

    public boolean isSetListOfTransitions() {
        return this.listOfTransitions != null && !this.listOfTransitions.isEmpty();
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public void setListOfQualitativeSpecies(ListOf<QualitativeSpecies> listOfQualitativeSpecies) {
        this.unsetListOfQualitativeSpecies();
        this.listOfQualitativeSpecies = listOfQualitativeSpecies;
        if (listOfQualitativeSpecies != null) {
            listOfQualitativeSpecies.setPackageVersion(-1);
            listOfQualitativeSpecies.setPackageName(null);
            listOfQualitativeSpecies.setPackageName("qual");
            listOfQualitativeSpecies.setSBaseListType(ListOf.Type.other);
        }
        if (this.isSetExtendedSBase()) {
            this.getModel().registerChild(this.listOfQualitativeSpecies);
        }
    }

    public void setListOfTransitions(ListOf<Transition> listOfTransitions) {
        this.unsetListOfTransitions();
        this.listOfTransitions = listOfTransitions;
        if (listOfTransitions != null) {
            listOfTransitions.setPackageVersion(-1);
            listOfTransitions.setPackageName(null);
            listOfTransitions.setPackageName("qual");
            listOfTransitions.setSBaseListType(ListOf.Type.other);
        }
        if (this.isSetExtendedSBase()) {
            this.getModel().registerChild(this.listOfTransitions);
        }
    }

    public Map<String, String> writeXMLAttributes() {
        return null;
    }

    public boolean unsetListOfTransitions() {
        if (this.isSetListOfTransitions()) {
            this.listOfTransitions.fireNodeRemovedEvent();
            this.listOfTransitions = null;
            return true;
        }
        return false;
    }

    public boolean unsetListOfQualitativeSpecies() {
        if (this.isSetListOfQualitativeSpecies()) {
            this.listOfQualitativeSpecies.fireNodeRemovedEvent();
            this.listOfQualitativeSpecies = null;
            return true;
        }
        return false;
    }
}

