/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.qual;

import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.CompartmentalizedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.util.StringTools;

public class QualitativeSpecies
extends AbstractNamedSBase
implements CompartmentalizedSBase,
UniqueNamedSBase {
    private static final long serialVersionUID = -6048861420699176889L;
    private String compartment;
    private Boolean constant;
    private Integer initialLevel;
    private Integer maxLevel;

    public QualitativeSpecies() {
        this.initDefaults();
    }

    public QualitativeSpecies(int level, int version) {
        this(null, null, level, version);
    }

    public QualitativeSpecies(QualitativeSpecies qualSpecies) {
        super((AbstractNamedSBase)qualSpecies);
        if (qualSpecies.isSetCompartment()) {
            this.setCompartment(qualSpecies.getCompartment());
        }
        if (qualSpecies.isSetConstant()) {
            this.setConstant(qualSpecies.getConstant());
        }
        if (qualSpecies.isSetInitialLevel()) {
            this.setInitialLevel(qualSpecies.getInitialLevel());
        }
        if (qualSpecies.isSetMaxLevel()) {
            this.setMaxLevel(qualSpecies.getMaxLevel());
        }
    }

    public QualitativeSpecies(Species species) {
        super((AbstractNamedSBase)species);
        this.initDefaults();
        if (species.isSetCompartment()) {
            this.compartment = species.getCompartment();
        }
        if (species.isSetConstant()) {
            this.constant = species.getConstant();
        }
    }

    public QualitativeSpecies(String id) {
        super(id);
        this.initDefaults();
    }

    public QualitativeSpecies(String id, int level, int version) {
        this(id, null, level, version);
    }

    public QualitativeSpecies(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public QualitativeSpecies clone() {
        return new QualitativeSpecies(this);
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            QualitativeSpecies qs = (QualitativeSpecies)((Object)object);
            if ((equals &= qs.isSetConstant() == this.isSetConstant()) && this.isSetConstant()) {
                equals &= qs.getConstant() == this.getConstant();
            }
            if ((equals &= qs.isSetCompartment() == this.isSetCompartment()) && this.isSetCompartment()) {
                equals &= qs.getCompartment().equals(this.getCompartment());
            }
            if ((equals &= qs.isSetInitialLevel() == this.isSetInitialLevel()) && this.isSetInitialLevel()) {
                equals &= qs.getInitialLevel() == this.getInitialLevel();
            }
            if ((equals &= qs.isSetMaxLevel() == this.isSetMaxLevel()) && this.isSetMaxLevel()) {
                equals &= qs.getMaxLevel() == this.getMaxLevel();
            }
        }
        return equals;
    }

    public String getCompartment() {
        return this.isSetCompartment() ? this.compartment : "";
    }

    public Compartment getCompartmentInstance() {
        Model model;
        if (this.isSetCompartment() && (model = this.getModel()) != null) {
            return model.getCompartment(this.getCompartment());
        }
        return null;
    }

    public boolean getConstant() {
        if (this.isSetConstant()) {
            return this.constant;
        }
        throw new PropertyUndefinedError("constant", (SBase)this);
    }

    public int getInitialLevel() {
        if (this.isSetInitialLevel()) {
            return this.initialLevel;
        }
        throw new PropertyUndefinedError("initialLevel", (SBase)this);
    }

    public int getMaxLevel() {
        if (this.isSetMaxLevel()) {
            return this.maxLevel;
        }
        throw new PropertyUndefinedError("maxLevel", (SBase)this);
    }

    public int hashCode() {
        int prime = 971;
        int hashCode = super.hashCode();
        if (this.isSetConstant()) {
            hashCode += 971 + (this.getConstant() ? 1 : -1);
        }
        if (this.isSetCompartment()) {
            hashCode += 971 * this.getCompartment().hashCode();
        }
        if (this.isSetInitialLevel()) {
            hashCode += 971 * this.getInitialLevel();
        }
        if (this.isSetMaxLevel()) {
            hashCode += 971 * this.getMaxLevel();
        }
        return hashCode;
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "qual";
        this.compartment = null;
        this.constant = null;
    }

    public boolean isCompartmentMandatory() {
        return true;
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isInitialLevelMandatory() {
        return false;
    }

    public boolean isMaxLevelMandatory() {
        return false;
    }

    public boolean isSetCompartment() {
        return this.compartment != null;
    }

    public boolean isSetCompartmentInstance() {
        return this.getCompartmentInstance() != null;
    }

    public boolean isSetConstant() {
        return this.constant != null;
    }

    public boolean isSetConstantMandatory() {
        return true;
    }

    public boolean isSetInitialLevel() {
        return this.initialLevel != null;
    }

    public boolean isSetMaxLevel() {
        return this.maxLevel != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("constant")) {
                this.setConstant(StringTools.parseSBMLBoolean((String)value));
            } else if (attributeName.equals("compartment")) {
                this.setCompartment(value);
            } else if (attributeName.equals("initialLevel")) {
                this.setInitialLevel(StringTools.parseSBMLInt((String)value));
            } else if (attributeName.equals("maxLevel")) {
                this.setMaxLevel(StringTools.parseSBMLInt((String)value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public boolean setCompartment(Compartment compartment) {
        if (compartment != null) {
            return this.setCompartment(compartment.getId());
        }
        return this.unsetCompartment();
    }

    public boolean setCompartment(String compartment) {
        if (compartment != this.compartment) {
            String oldCompartment = this.compartment;
            this.compartment = compartment == null || compartment.length() == 0 ? null : compartment;
            this.firePropertyChange("compartment", oldCompartment, this.compartment);
            return true;
        }
        return false;
    }

    public void setConstant(boolean constant) {
        Boolean oldConstant = this.constant;
        this.constant = constant;
        this.firePropertyChange("constant", oldConstant, this.constant);
    }

    public void setInitialLevel(int initialLevel) {
        Integer oldInitialLevel = this.initialLevel;
        this.initialLevel = initialLevel;
        this.firePropertyChange("initialLevel", oldInitialLevel, this.initialLevel);
    }

    public void setMaxLevel(int maxLevel) {
        Integer oldMaxLevel = this.maxLevel;
        this.maxLevel = maxLevel;
        this.firePropertyChange("maxLevel", oldMaxLevel, this.maxLevel);
    }

    public boolean unsetCompartment() {
        return this.setCompartment((String)null);
    }

    public boolean unsetConstant() {
        if (this.isSetConstant()) {
            boolean oldConstant = this.constant;
            this.constant = null;
            this.firePropertyChange("constant", oldConstant, this.constant);
            return true;
        }
        return false;
    }

    public boolean unsetInitialLevel() {
        if (this.isSetInitialLevel()) {
            Integer oldInitialLevel = this.initialLevel;
            this.initialLevel = null;
            this.firePropertyChange("initialLevel", oldInitialLevel, this.initialLevel);
            return true;
        }
        return false;
    }

    public boolean unsetMaxLevel() {
        if (this.isSetMaxLevel()) {
            Integer oldMaxLevel = this.maxLevel;
            this.maxLevel = null;
            this.firePropertyChange("maxLevel", oldMaxLevel, this.maxLevel);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("qual:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("qual:name", this.getName());
        }
        if (this.isSetConstant()) {
            attributes.put("qual:constant", Boolean.toString(this.getConstant()));
        }
        if (this.isSetCompartment()) {
            attributes.put("qual:compartment", this.getCompartment());
        }
        if (this.isSetInitialLevel()) {
            attributes.put("qual:initialLevel", Integer.toString(this.getInitialLevel()));
        }
        if (this.isSetMaxLevel()) {
            attributes.put("qual:maxLevel", Integer.toString(this.getMaxLevel()));
        }
        return attributes;
    }
}

