/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.QualConstants;
import org.sbml.jsbml.ext.qual.QualList;
import org.sbml.jsbml.ext.qual.QualModelPlugin;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class QualParser
extends AbstractReaderWriter
implements PackageParser {
    private QualList groupList = QualList.none;
    private static final transient Logger logger = Logger.getLogger(QualParser.class);

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + sbase.getClass().getCanonicalName()));
        }
        ArrayList<Object> listOfElementsToWrite = new ArrayList<Object>();
        if (sbase instanceof Model) {
            QualModelPlugin modelGE = (QualModelPlugin)((Model)sbase).getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1");
            Enumeration children = modelGE.children();
            while (children.hasMoreElements()) {
                listOfElementsToWrite.add(children.nextElement());
            }
        } else if (sbase instanceof TreeNode) {
            Enumeration<? extends TreeNode> children = ((TreeNode)sbase).children();
            while (children.hasMoreElements()) {
                listOfElementsToWrite.add(children.nextElement());
            }
        }
        if (listOfElementsToWrite.isEmpty()) {
            listOfElementsToWrite = null;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite size = " + listOfElementsToWrite.size()));
        }
        return listOfElementsToWrite;
    }

    public boolean processEndElement(String elementName, String prefix, boolean isNested, Object contextObject) {
        if (elementName.equals("listOfQualitativeSpecies") || elementName.equals("listOfTransitions")) {
            this.groupList = QualList.none;
        }
        if (elementName.equals("listOfInputs") || elementName.equals("listOfOutputs") || elementName.equals("listOfFunctionTerms")) {
            this.groupList = QualList.listOfTransitions;
        }
        if (elementName.equals("listOfSymbolicValues")) {
            this.groupList = QualList.listOfQualitativeSpecies;
        }
        return true;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            QualModelPlugin qualModel = null;
            if (model.getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1") != null) {
                qualModel = (QualModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1");
            } else {
                qualModel = new QualModelPlugin(model);
                model.addExtension("http://www.sbml.org/sbml/level3/version1/qual/version1", (SBasePlugin)qualModel);
            }
            if (elementName.equals("listOfQualitativeSpecies")) {
                ListOf<QualitativeSpecies> listOfQualitativeSpecies = qualModel.getListOfQualitativeSpecies();
                this.groupList = QualList.listOfQualitativeSpecies;
                return listOfQualitativeSpecies;
            }
            if (elementName.equals("listOfTransitions")) {
                ListOf<Transition> listOfObjectives = qualModel.getListOfTransitions();
                this.groupList = QualList.listOfTransitions;
                return listOfObjectives;
            }
        } else if (contextObject instanceof Transition) {
            Transition transition = (Transition)((Object)contextObject);
            if (elementName.equals("listOfInputs")) {
                ListOf<Input> listOfInputs = transition.getListOfInputs();
                this.groupList = QualList.listOfInputs;
                return listOfInputs;
            }
            if (elementName.equals("listOfOutputs")) {
                ListOf<Output> listOfOutputs = transition.getListOfOutputs();
                this.groupList = QualList.listOfOutputs;
                return listOfOutputs;
            }
            if (elementName.equals("listOfFunctionTerms")) {
                ListOf<FunctionTerm> listOfFunctionTerms = transition.getListOfFunctionTerms();
                this.groupList = QualList.listOfFunctionTerms;
                return listOfFunctionTerms;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            if (elementName.equals("transition") && this.groupList.equals((Object)QualList.listOfTransitions)) {
                Model model = (Model)listOf.getParentSBMLObject();
                QualModelPlugin extendeModel = (QualModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1");
                Transition transition = new Transition();
                extendeModel.addTransition(transition);
                return transition;
            }
            if (elementName.equals("qualitativeSpecies") && this.groupList.equals((Object)QualList.listOfQualitativeSpecies)) {
                Model model = (Model)listOf.getParentSBMLObject();
                QualModelPlugin extendeModel = (QualModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1");
                QualitativeSpecies qualSpecies = new QualitativeSpecies();
                extendeModel.addQualitativeSpecies(qualSpecies);
                return qualSpecies;
            }
            if (elementName.equals("input") && this.groupList.equals((Object)QualList.listOfInputs)) {
                Transition transition = (Transition)listOf.getParentSBMLObject();
                Input input = new Input();
                transition.addInput(input);
                return input;
            }
            if (elementName.equals("output") && this.groupList.equals((Object)QualList.listOfOutputs)) {
                Transition transition = (Transition)listOf.getParentSBMLObject();
                Output output = new Output();
                transition.addOutput(output);
                return output;
            }
            if (elementName.equals("functionTerm") && this.groupList.equals((Object)QualList.listOfFunctionTerms)) {
                Transition transition = (Transition)listOf.getParentSBMLObject();
                FunctionTerm functionTerm = new FunctionTerm();
                transition.addFunctionTerm(functionTerm);
                return functionTerm;
            }
            if (elementName.equals("defaultTerm") && this.groupList.equals((Object)QualList.listOfFunctionTerms)) {
                Transition transition = (Transition)listOf.getParentSBMLObject();
                FunctionTerm functionTerm = new FunctionTerm();
                functionTerm.setDefaultTerm(true);
                transition.addFunctionTerm(functionTerm);
                return functionTerm;
            }
        }
        return contextObject;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("writeElement: " + sbmlElementToWrite.getClass().getSimpleName()));
        }
        if (sbmlElementToWrite instanceof FunctionTerm && ((FunctionTerm)((Object)sbmlElementToWrite)).isDefaultTerm()) {
            xmlObject.setName("defaultTerm");
        }
    }

    public String getShortLabel() {
        return "qual";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/qual/version1";
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/qual/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return QualConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return this.getShortLabel();
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null && sbase instanceof Model) {
            return new QualModelPlugin((Model)sbase);
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

