/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.qual;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.InputTransitionEffect;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;

public class Transition
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = 8343744362262634585L;
    private ListOf<FunctionTerm> listOfFunctionTerms;
    private ListOf<Input> listOfInputs;
    private ListOf<Output> listOfOutputs;

    public Transition() {
        this.initDefaults();
    }

    public Transition(int level, int version) {
        this(null, null, level, version);
    }

    public Transition(String id) {
        super(id);
        this.initDefaults();
    }

    public Transition(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Transition(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public Transition(Transition t) {
        super((AbstractNamedSBase)t);
        if (t.isSetListOfFunctionTerms()) {
            this.setListOfFunctionTerms((ListOf<FunctionTerm>)t.getListOfFunctionTerms().clone());
        }
        if (t.isSetListOfInputs()) {
            this.setListOfInputs((ListOf<Input>)t.getListOfInputs().clone());
        }
        if (t.isSetListOfOutputs()) {
            this.setListOfOutputs((ListOf<Output>)t.getListOfOutputs().clone());
        }
    }

    public boolean addFunctionTerm(FunctionTerm functionTerm) {
        return this.getListOfFunctionTerms().add((SBase)functionTerm);
    }

    public boolean addInput(Input input) {
        return this.getListOfInputs().add((SBase)input);
    }

    public boolean addOutput(Output output) {
        return this.getListOfOutputs().add((SBase)output);
    }

    public Transition clone() {
        return new Transition(this);
    }

    public FunctionTerm createFunctionTerm() {
        return this.createFunctionTerm(null);
    }

    public FunctionTerm createFunctionTerm(ASTNode math) {
        FunctionTerm ft = new FunctionTerm(math, this.getLevel(), this.getVersion());
        return this.addFunctionTerm(ft) ? ft : null;
    }

    public Input createInput() {
        return this.createInput(null);
    }

    public Input createInput(String id) {
        Input input = new Input(id, this.getLevel(), this.getVersion());
        this.addInput(input);
        return input;
    }

    public Input createInput(String id, QualitativeSpecies qualitativeSpecies, InputTransitionEffect transitionEffect) {
        return this.createInput(id, qualitativeSpecies.getId(), transitionEffect);
    }

    public Input createInput(String id, String input_species_id, InputTransitionEffect transitionEffect) {
        Input input = this.createInput(id);
        input.setQualitativeSpecies(input_species_id);
        input.setTransitionEffect(transitionEffect);
        return input;
    }

    public Output createOutput() {
        return this.createOutput(null);
    }

    public Output createOutput(String id) {
        Output output = new Output(id, this.getLevel(), this.getVersion());
        this.addOutput(output);
        return output;
    }

    public Output createOutput(String id, QualitativeSpecies qualitativeSpecies, OutputTransitionEffect transitionEffect) {
        return this.createOutput(id, qualitativeSpecies.getId(), transitionEffect);
    }

    public Output createOutput(String id, String output_species_id, OutputTransitionEffect transitionEffect) {
        Output Output2 = this.createOutput(id);
        Output2.setQualitativeSpecies(output_species_id);
        Output2.setTransitionEffect(transitionEffect);
        return Output2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)((Object)obj);
        if (this.listOfFunctionTerms == null ? other.listOfFunctionTerms != null : !this.listOfFunctionTerms.equals(other.listOfFunctionTerms)) {
            return false;
        }
        if (this.listOfInputs == null ? other.listOfInputs != null : !this.listOfInputs.equals(other.listOfInputs)) {
            return false;
        }
        return !(this.listOfOutputs == null ? other.listOfOutputs != null : !this.listOfOutputs.equals(other.listOfOutputs));
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfInputs()) {
            if (pos == index) {
                return this.getListOfInputs();
            }
            ++pos;
        }
        if (this.isSetListOfOutputs()) {
            if (pos == index) {
                return this.getListOfOutputs();
            }
            ++pos;
        }
        if (this.isSetListOfFunctionTerms()) {
            if (pos == index) {
                return this.getListOfFunctionTerms();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfInputs()) {
            ++count;
        }
        if (this.isSetListOfOutputs()) {
            ++count;
        }
        if (this.isSetListOfFunctionTerms()) {
            ++count;
        }
        return count;
    }

    public int getFunctionTermCount() {
        return this.isSetListOfFunctionTerms() ? this.getListOfFunctionTerms().size() : 0;
    }

    public int getInputCount() {
        return this.isSetListOfInputs() ? this.getListOfInputs().size() : 0;
    }

    public ListOf<FunctionTerm> getListOfFunctionTerms() {
        if (!this.isSetListOfFunctionTerms()) {
            this.listOfFunctionTerms = new ListOf(this.getLevel(), this.getVersion());
            this.listOfFunctionTerms.setSBaseListType(ListOf.Type.other);
            this.listOfFunctionTerms.setPackageVersion(-1);
            this.listOfFunctionTerms.setPackageName(null);
            this.listOfFunctionTerms.setPackageName("qual");
            this.listOfFunctionTerms.setOtherListName("listOfFunctionTerms");
            this.registerChild((SBase)this.listOfFunctionTerms);
        }
        return this.listOfFunctionTerms;
    }

    public ListOf<Input> getListOfInputs() {
        if (!this.isSetListOfInputs()) {
            this.listOfInputs = new ListOf(this.getLevel(), this.getVersion());
            this.listOfInputs.setSBaseListType(ListOf.Type.other);
            this.listOfInputs.setPackageVersion(-1);
            this.listOfInputs.setPackageName(null);
            this.listOfInputs.setPackageName("qual");
            this.listOfInputs.setOtherListName("listOfInputs");
            this.registerChild((SBase)this.listOfInputs);
        }
        return this.listOfInputs;
    }

    public ListOf<Output> getListOfOutputs() {
        if (!this.isSetListOfOutputs()) {
            this.listOfOutputs = new ListOf(this.getLevel(), this.getVersion());
            this.listOfOutputs.setSBaseListType(ListOf.Type.other);
            this.listOfOutputs.setPackageVersion(-1);
            this.listOfOutputs.setPackageName(null);
            this.listOfOutputs.setPackageName("qual");
            this.listOfOutputs.setOtherListName("listOfOutputs");
            this.registerChild((SBase)this.listOfOutputs);
        }
        return this.listOfOutputs;
    }

    public int getOutputCount() {
        return this.isSetListOfOutputs() ? this.getListOfOutputs().size() : 0;
    }

    public int hashCode() {
        int prime = 1259;
        int result = super.hashCode();
        result = 1259 * result + (this.listOfFunctionTerms == null ? 0 : this.listOfFunctionTerms.hashCode());
        result = 1259 * result + (this.listOfInputs == null ? 0 : this.listOfInputs.hashCode());
        result = 1259 * result + (this.listOfOutputs == null ? 0 : this.listOfOutputs.hashCode());
        return result;
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "qual";
        this.listOfFunctionTerms = null;
        this.listOfInputs = null;
        this.listOfOutputs = null;
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isListOfFunctionTermsMandatory() {
        return false;
    }

    public boolean isListOfInputsMandatory() {
        return false;
    }

    public boolean isListOfOutputsMandatory() {
        return true;
    }

    public boolean isSetListOfFunctionTerms() {
        return this.listOfFunctionTerms != null;
    }

    public boolean isSetListOfInputs() {
        return this.listOfInputs != null;
    }

    public boolean isSetListOfOutputs() {
        return this.listOfOutputs != null;
    }

    public boolean isSignMandatory() {
        return false;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        return isAttributeRead;
    }

    public boolean removeFunctionTerm(FunctionTerm functionTerm) {
        if (this.isSetListOfFunctionTerms()) {
            return this.listOfFunctionTerms.remove((Object)functionTerm);
        }
        return false;
    }

    public void removeFunctionTerm(int i) {
        if (!this.isSetListOfFunctionTerms()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.listOfFunctionTerms.remove(i);
    }

    public boolean removeInput(Input input) {
        if (this.isSetListOfInputs()) {
            return this.listOfInputs.remove((NamedSBase)input);
        }
        return false;
    }

    public void removeInput(int i) {
        if (!this.isSetListOfInputs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.listOfInputs.remove(i);
    }

    public void removeOutput(int i) {
        if (!this.isSetListOfOutputs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.listOfOutputs.remove(i);
    }

    public boolean removeOutput(Output output) {
        if (this.isSetListOfOutputs()) {
            return this.listOfOutputs.remove((NamedSBase)output);
        }
        return false;
    }

    public void setListOfFunctionTerms(ListOf<FunctionTerm> loft) {
        this.unsetListOfFunctionTerms();
        this.listOfFunctionTerms = loft;
        if (this.listOfFunctionTerms != null) {
            this.listOfFunctionTerms.setPackageVersion(-1);
            this.listOfFunctionTerms.setPackageName(null);
            this.listOfFunctionTerms.setPackageName("qual");
            this.listOfFunctionTerms.setSBaseListType(ListOf.Type.other);
            this.listOfFunctionTerms.setOtherListName("listOfFunctionTerms");
            this.registerChild((SBase)this.listOfFunctionTerms);
        }
    }

    public void setListOfInputs(ListOf<Input> loi) {
        this.unsetListOfInputs();
        this.listOfInputs = loi;
        if (this.listOfInputs != null) {
            this.listOfInputs.setPackageVersion(-1);
            this.listOfInputs.setPackageName(null);
            this.listOfInputs.setPackageName("qual");
            this.listOfInputs.setSBaseListType(ListOf.Type.other);
            this.listOfInputs.setOtherListName("listOfInputs");
            this.registerChild((SBase)this.listOfInputs);
        }
    }

    public void setListOfOutputs(ListOf<Output> loo) {
        this.unsetListOfOutputs();
        this.listOfOutputs = loo;
        if (this.listOfOutputs != null) {
            this.listOfOutputs.setPackageVersion(-1);
            this.listOfOutputs.setPackageName(null);
            this.listOfOutputs.setPackageName("qual");
            this.listOfOutputs.setSBaseListType(ListOf.Type.other);
            this.listOfOutputs.setOtherListName("listOfOutputs");
            this.registerChild((SBase)this.listOfOutputs);
        }
    }

    public boolean unsetListOfFunctionTerms() {
        if (this.isSetListOfFunctionTerms()) {
            ListOf<FunctionTerm> oldLoft = this.listOfFunctionTerms;
            this.listOfFunctionTerms = null;
            oldLoft.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfInputs() {
        if (this.isSetListOfInputs()) {
            ListOf<Input> oldLoi = this.listOfInputs;
            this.listOfInputs = null;
            oldLoi.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfOutputs() {
        if (this.isSetListOfOutputs()) {
            ListOf<Output> oldLoo = this.listOfOutputs;
            this.listOfOutputs = null;
            oldLoo.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("qual:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("qual:name", this.getName());
        }
        return attributes;
    }
}

