/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.QualModelPlugin;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class QualitativeSpeciesConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 3020301, 3020310);
                this.addRangeToSet(set, 3020312, 3020313);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                if (level < 3) break;
                set.add(3020311);
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 3020302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020303: {
                func = new UnknownPackageAttributeValidationFunction<QualitativeSpecies>("qual"){

                    public boolean check(ValidationContext ctx, QualitativeSpecies t) {
                        if (!(t.isSetConstant() && t.isSetCompartment() && t.isSetId())) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)t);
                    }
                };
                break;
            }
            case 3020304: {
                func = new InvalidAttributeValidationFunction("constant");
                break;
            }
            case 3020305: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020306: {
                func = new InvalidAttributeValidationFunction("initialLevel");
                break;
            }
            case 3020307: {
                func = new InvalidAttributeValidationFunction("maxLevel");
                break;
            }
            case 3020308: {
                func = new AbstractValidationFunction<QualitativeSpecies>(){

                    public boolean check(ValidationContext ctx, QualitativeSpecies qs) {
                        if (qs.isSetCompartment() && qs.getModel() != null && qs.getCompartmentInstance() == null) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020308, (String[])new String[]{qs.getId(), qs.getCompartment()});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020309: {
                func = new ValidationFunction<QualitativeSpecies>(){

                    public boolean check(ValidationContext ctx, QualitativeSpecies qs) {
                        return !qs.isSetInitialLevel() || !qs.isSetMaxLevel() || qs.getInitialLevel() <= qs.getMaxLevel();
                    }
                };
                break;
            }
            case 3020310: {
                func = new ValidationFunction<QualitativeSpecies>(){

                    public boolean check(ValidationContext ctx, QualitativeSpecies qs) {
                        if (qs.isSetConstant() && qs.getConstant()) {
                            QualModelPlugin qmp = (QualModelPlugin)qs.getModel().getPlugin(qs.getNamespace());
                            for (Transition trans : qmp.getListOfTransitions()) {
                                for (Output output : trans.getListOfOutputs()) {
                                    if (!output.getQualitativeSpecies().equals(qs.getId())) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020311: {
                break;
            }
            case 3020312: {
                func = new ValidationFunction<QualitativeSpecies>(){

                    public boolean check(ValidationContext ctx, QualitativeSpecies qs) {
                        return !qs.isSetInitialLevel() || qs.getInitialLevel() >= 0;
                    }
                };
                break;
            }
            case 3020313: {
                func = new ValidationFunction<QualitativeSpecies>(){

                    public boolean check(ValidationContext ctx, QualitativeSpecies qs) {
                        return !qs.isSetMaxLevel() || qs.getMaxLevel() >= 0;
                    }
                };
            }
        }
        return func;
    }
}

