/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class OutputConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020601, 3020610);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 3020602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020603: {
                func = new UnknownPackageAttributeValidationFunction<Output>("qual"){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (!o.isSetQualitativeSpecies() || !o.isSetTransitionEffect()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)o);
                    }
                };
                break;
            }
            case 3020604: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020605: {
                func = new InvalidAttributeValidationFunction("transitionEffect");
                break;
            }
            case 3020606: {
                func = new InvalidAttributeValidationFunction("outputLevel");
                break;
            }
            case 3020607: {
                func = new ValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        return !o.isSetQualitativeSpecies() || o.getQualitativeSpeciesInstance() != null;
                    }
                };
                break;
            }
            case 3020608: {
                func = new ValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        return !o.isSetQualitativeSpecies() || o.getQualitativeSpeciesInstance() == null || !o.getQualitativeSpeciesInstance().isSetConstant() || o.getQualitativeSpeciesInstance().getConstant();
                    }
                };
                break;
            }
            case 3020609: {
                func = new ValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        return !o.isSetTransitionEffect() || o.getTransitionEffect() != OutputTransitionEffect.production || o.isSetOutputLevel();
                    }
                };
                break;
            }
            case 3020610: {
                func = new ValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        return !o.isSetOutputLevel() || o.getOutputLevel() >= 0;
                    }
                };
            }
        }
        return func;
    }
}

