/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class TransitionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020401, 3020414);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020401: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 3020402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020403: {
                func = new UnknownPackageAttributeValidationFunction("qual");
                break;
            }
            case 3020404: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020405: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        Boolean functionTerm = false;
                        if (t.isSetListOfFunctionTerms() && t.getListOfFunctionTerms().size() > 0) {
                            functionTerm = new DuplicatedElementValidationFunction("listOfFunctionTerms").check(ctx, (SBase)t);
                        }
                        Boolean input = new DuplicatedElementValidationFunction("listOfInputs").check(ctx, (SBase)t);
                        Boolean output = new DuplicatedElementValidationFunction("listOfOutputs").check(ctx, (SBase)t);
                        return functionTerm != false && input != false && output != false;
                    }
                };
                break;
            }
            case 3020406: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        return !(t.isSetListOfInputs() && t.getListOfInputs().isEmpty() || t.isSetListOfOutputs() && t.getListOfOutputs().isEmpty());
                    }
                };
                break;
            }
            case 3020407: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfInputs() || t.getListOfInputs().isEmpty()) {
                            UnknownElementValidationFunction unFunc = new UnknownElementValidationFunction();
                            return unFunc.check(ctx, t.getListOfInputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020408: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfOutputs() || t.getListOfOutputs().isEmpty()) {
                            UnknownElementValidationFunction unFunc = new UnknownElementValidationFunction();
                            return unFunc.check(ctx, t.getListOfOutputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020409: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfFunctionTerms() && !t.getListOfFunctionTerms().isEmpty()) {
                            Boolean hasDefaultTerm = false;
                            for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                                if (!ft.isDefaultTerm()) continue;
                                hasDefaultTerm = true;
                            }
                            Boolean onlyDefaultTerm = new DuplicatedElementValidationFunction("defaultTerm").check(ctx, t.getListOfFunctionTerms());
                            Boolean onlyFuntionTermObjects = new UnknownElementValidationFunction().check(ctx, t.getListOfFunctionTerms());
                            return hasDefaultTerm != false && onlyDefaultTerm != false && onlyFuntionTermObjects != false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020410: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfInputs()) {
                            UnknownAttributeValidationFunction unFunc = new UnknownAttributeValidationFunction();
                            return unFunc.check(ctx, t.getListOfInputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020411: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfOutputs()) {
                            UnknownAttributeValidationFunction unFunc = new UnknownAttributeValidationFunction();
                            return unFunc.check(ctx, t.getListOfOutputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020412: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfFunctionTerms()) {
                            UnknownAttributeValidationFunction unFunc = new UnknownAttributeValidationFunction();
                            return unFunc.check(ctx, t.getListOfFunctionTerms());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020413: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        int maxLevel = Integer.MIN_VALUE;
                        for (Output o : t.getListOfOutputs()) {
                            int newMaxLevel;
                            if (o.isSetQualitativeSpecies() && o.getQualitativeSpeciesInstance() != null && o.getQualitativeSpeciesInstance().isSetMaxLevel() && (newMaxLevel = o.getQualitativeSpeciesInstance().getMaxLevel()) > maxLevel) {
                                maxLevel = newMaxLevel;
                            }
                            for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                                int resultLevel;
                                if (!ft.isSetResultLevel() || (resultLevel = ft.getResultLevel()) <= maxLevel) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020414: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                            if (!ft.isSetResultLevel() || ft.getResultLevel() >= 0) continue;
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

