/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedMathValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeAbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class FunctionTermConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020801, 3020806);
                    this.addRangeToSet(set, 3020701, 3020705);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 3010201, 3010202);
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3010201: {
                func = new AbstractValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (ft.isSetMath()) {
                            if (!ft.getMath().isBoolean()) {
                                ValidationConstraint.logError((ValidationContext)ctx, (int)3010201, (SBase)ft, (String[])new String[]{ft.getId()});
                            }
                            return ft.getMath().isBoolean();
                        }
                        return true;
                    }
                };
                break;
            }
            case 3010202: {
                break;
            }
            case 3020701: {
                func = new AbstractValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        boolean func = true;
                        if (ft.isDefaultTerm()) {
                            func = new UnknownCoreAttributeAbstractValidationFunction().check(ctx, (TreeNodeWithChangeSupport)ft, 3020701);
                            return func;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020702: {
                func = new UnknownCoreElementValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020703: {
                func = new UnknownPackageAttributeValidationFunction<FunctionTerm>("qual"){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (ft.isDefaultTerm() && !ft.isSetResultLevel()) {
                            return false;
                        }
                        if (ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020704: {
                func = new InvalidAttributeValidationFunction<FunctionTerm>("resultLevel"){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020705: {
                func = new AbstractValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (ft.isDefaultTerm() && ft.isSetResultLevel() && ft.getResultLevel() < 0) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020705, (SBase)ft, (String[])new String[]{"Default Term", Integer.valueOf(ft.getResultLevel()).toString()});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020801: {
                func = new AbstractValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        boolean func = true;
                        if (!ft.isDefaultTerm()) {
                            func = new UnknownCoreAttributeValidationFunction().check(ctx, (TreeNodeWithChangeSupport)ft);
                            if (!func) {
                                ValidationConstraint.logError((ValidationContext)ctx, (int)3020801, (SBase)ft, (String[])new String[]{"TheBrokenAtt"});
                            }
                            return func;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020802: {
                func = new UnknownCoreElementValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (!ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020803: {
                func = new UnknownPackageAttributeValidationFunction<FunctionTerm>("qual"){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (!ft.isDefaultTerm() && !ft.isSetResultLevel()) {
                            return false;
                        }
                        if (!ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020804: {
                func = new DuplicatedMathValidationFunction<FunctionTerm>(true){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (!ft.isDefaultTerm()) {
                            return super.check(ctx, (MathContainer)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020805: {
                func = new InvalidAttributeValidationFunction<FunctionTerm>("resultLevel"){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (!ft.isDefaultTerm()) {
                            return super.check(ctx, (TreeNodeWithChangeSupport)ft);
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020806: {
                func = new AbstractValidationFunction<FunctionTerm>(){

                    public boolean check(ValidationContext ctx, FunctionTerm ft) {
                        if (!ft.isDefaultTerm() && ft.isSetResultLevel() && ft.getResultLevel() < 0) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020806, (SBase)ft, (String[])new String[]{ft.getElementName(), Integer.valueOf(ft.getResultLevel()).toString()});
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

