/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.HashSet;
import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeAbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class OutputConstraints
extends AbstractConstraintDeclaration {
    protected static final String SET_20311 = "SET_20311";

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020601, 3020610);
                }
            }
            case MODELING_PRACTICE: {
                if (level < 3) break;
                set.add(3020311);
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, final ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020311: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (o.isSetTransitionEffect() && o.isSetQualitativeSpecies() && o.getTransitionEffect() == OutputTransitionEffect.assignmentLevel) {
                            HashSet<String> qlWithAssignmentLevel = (HashSet<String>)context.getHashMap().get(OutputConstraints.SET_20311);
                            if (qlWithAssignmentLevel == null) {
                                qlWithAssignmentLevel = new HashSet<String>();
                                context.getHashMap().put(OutputConstraints.SET_20311, qlWithAssignmentLevel);
                            }
                            if (qlWithAssignmentLevel.contains(o.getQualitativeSpecies())) {
                                ValidationConstraint.logError((ValidationContext)ctx, (int)3020311, (SBase)o, (String[])new String[]{((Transition)((Object)o.getParent().getParent())).getId(), o.getQualitativeSpecies()});
                                return false;
                            }
                            qlWithAssignmentLevel.add(o.getQualitativeSpecies());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020601: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        return new UnknownCoreAttributeAbstractValidationFunction().check(ctx, (TreeNodeWithChangeSupport)o, 3020601);
                    }
                };
                break;
            }
            case 3020602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020603: {
                func = new UnknownPackageAttributeValidationFunction<Output>("qual"){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (!o.isSetQualitativeSpecies() || !o.isSetTransitionEffect()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)o);
                    }
                };
                break;
            }
            case 3020604: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020605: {
                func = new InvalidAttributeValidationFunction("transitionEffect");
                break;
            }
            case 3020606: {
                func = new InvalidAttributeValidationFunction("outputLevel");
                break;
            }
            case 3020607: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (o.isSetQualitativeSpecies() && o.getQualitativeSpeciesInstance() == null) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020607, (SBase)o, (String[])new String[]{o.getQualitativeSpecies()});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020608: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (o.isSetQualitativeSpecies() && o.getQualitativeSpeciesInstance() != null && o.getQualitativeSpeciesInstance().isSetConstant() && o.getQualitativeSpeciesInstance().getConstant()) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020608, (SBase)o, (String[])new String[]{o.getId(), Boolean.toString(o.getQualitativeSpeciesInstance().getConstant())});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020609: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (o.isSetTransitionEffect() && o.getTransitionEffect() == OutputTransitionEffect.production && !o.isSetOutputLevel()) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020609, (SBase)o, (String[])new String[]{o.getTransitionEffect().name(), Boolean.toString(o.isSetOutputLevel())});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020610: {
                func = new AbstractValidationFunction<Output>(){

                    public boolean check(ValidationContext ctx, Output o) {
                        if (o.isSetOutputLevel() && o.getOutputLevel() < 0) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020610, (SBase)o, (String[])new String[]{o.getId(), Integer.toString(o.getOutputLevel())});
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

