/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.qual.QualModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class QualModelPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3010101, 3020102);
                    set.add(3010301);
                    this.addRangeToSet(set, 3020201, 3020206);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3010101: {
                break;
            }
            case 3010102: {
                break;
            }
            case 3010301: {
                break;
            }
            case 3020201: {
                func = new ValidationFunction<QualModelPlugin>(){

                    public boolean check(ValidationContext ctx, QualModelPlugin qmp) {
                        Boolean onlyOneListOfTransition = new DuplicatedElementValidationFunction("listOfTransitions").check(ctx, (TreeNodeWithChangeSupport)qmp);
                        Boolean onlyOneListOfQualSpec = new DuplicatedElementValidationFunction("listOfQualitativeSpecies").check(ctx, (TreeNodeWithChangeSupport)qmp);
                        return onlyOneListOfTransition != false && onlyOneListOfQualSpec != false;
                    }
                };
                break;
            }
            case 3020202: {
                break;
            }
            case 3020203: {
                func = new ValidationFunction<QualModelPlugin>(){

                    public boolean check(ValidationContext ctx, QualModelPlugin qmp) {
                        if (qmp.isSetListOfTransitions()) {
                            return new UnknownElementValidationFunction().check(ctx, qmp.getListOfTransitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020204: {
                func = new ValidationFunction<QualModelPlugin>(){

                    public boolean check(ValidationContext ctx, QualModelPlugin qmp) {
                        if (qmp.isSetListOfQualitativeSpecies()) {
                            return new UnknownElementValidationFunction().check(ctx, qmp.getListOfQualitativeSpecies());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020205: {
                func = new ValidationFunction<QualModelPlugin>(){

                    public boolean check(ValidationContext ctx, QualModelPlugin qmp) {
                        if (qmp.isSetListOfQualitativeSpecies()) {
                            return new UnknownAttributeValidationFunction().check(ctx, qmp.getListOfQualitativeSpecies());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020206: {
                func = new ValidationFunction<QualModelPlugin>(){

                    public boolean check(ValidationContext ctx, QualModelPlugin qmp) {
                        if (qmp.isSetListOfTransitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, qmp.getListOfTransitions());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

