/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.qual;

import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.util.StringTools;

public class Output
extends AbstractNamedSBase
implements UniqueNamedSBase,
CallableSBase {
    private static final long serialVersionUID = -6392002023918667156L;
    private String qualitativeSpecies;
    private OutputTransitionEffect transitionEffect;
    private Integer outputLevel;

    public Output() {
        this.initDefaults();
    }

    public Output(String id) {
        super(id);
        this.initDefaults();
    }

    public Output(QualitativeSpecies qualitativeSpecies, OutputTransitionEffect transitionEffect) {
        this(null, qualitativeSpecies, transitionEffect);
    }

    public Output(String id, QualitativeSpecies qualitativeSpecies, OutputTransitionEffect transitionEffect) {
        this(id);
        this.setQualitativeSpecies(qualitativeSpecies.getId());
        this.setTransitionEffect(transitionEffect);
    }

    public Output(int level, int version) {
        this(null, null, level, version);
    }

    public Output(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Output(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public Output(Output out) {
        super((AbstractNamedSBase)out);
        if (out.isSetQualitativeSpecies()) {
            this.setQualitativeSpecies(new String(out.getQualitativeSpecies()));
        }
        if (out.isSetTransitionEffect()) {
            this.setTransitionEffect(out.getTransitionEffect());
        }
        if (out.isSetOutputLevel()) {
            this.setOutputLevel(out.getOutputLevel());
        }
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "qual";
        this.qualitativeSpecies = null;
        this.transitionEffect = null;
        this.outputLevel = null;
    }

    public Output clone() {
        return new Output(this);
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isQualitativeSpeciesMandatory() {
        return true;
    }

    public boolean isSetQualitativeSpecies() {
        return this.qualitativeSpecies != null;
    }

    public String getQualitativeSpecies() {
        if (this.isSetQualitativeSpecies()) {
            return this.qualitativeSpecies;
        }
        throw new PropertyUndefinedError("qualitativeSpecies", (SBase)this);
    }

    public QualitativeSpecies getQualitativeSpeciesInstance() {
        Model model;
        if (this.isSetQualitativeSpecies() && (model = this.getModel()) != null && model.getSBaseById(this.getQualitativeSpecies()) instanceof QualitativeSpecies) {
            return (QualitativeSpecies)model.getSBaseById(this.getQualitativeSpecies());
        }
        return null;
    }

    public void setQualitativeSpecies(String qualitativeSpecies) {
        String oldQualitativeSpecies = this.qualitativeSpecies;
        this.qualitativeSpecies = qualitativeSpecies;
        this.firePropertyChange("qualitativeSpecies", oldQualitativeSpecies, this.qualitativeSpecies);
    }

    public boolean unsetQualitativeSpecies() {
        if (this.isSetQualitativeSpecies()) {
            this.setQualitativeSpecies(null);
            return true;
        }
        return false;
    }

    public boolean isTransitionEffectMandatory() {
        return true;
    }

    public boolean isSetTransitionEffect() {
        return this.transitionEffect != null;
    }

    public OutputTransitionEffect getTransitionEffect() {
        if (this.isSetTransitionEffect()) {
            return this.transitionEffect;
        }
        throw new PropertyUndefinedError("transitionEffect", (SBase)this);
    }

    public void setTransitionEffect(OutputTransitionEffect transitionEffect) {
        OutputTransitionEffect oldTransitionEffect = this.transitionEffect;
        this.transitionEffect = transitionEffect;
        this.firePropertyChange("transitionEffect", (Object)oldTransitionEffect, (Object)this.transitionEffect);
    }

    public boolean unsetTransitionEffect() {
        if (this.isSetTransitionEffect()) {
            this.setTransitionEffect(null);
            return true;
        }
        return false;
    }

    public boolean isOutputLevelMandatory() {
        return false;
    }

    public boolean isSetOutputLevel() {
        return this.outputLevel != null;
    }

    public int getOutputLevel() {
        if (this.isSetOutputLevel()) {
            return this.outputLevel;
        }
        throw new PropertyUndefinedError("outputLevel", (SBase)this);
    }

    public void setOutputLevel(int level) {
        Integer oldLevel = this.outputLevel;
        this.outputLevel = level;
        this.firePropertyChange("outputLevel", oldLevel, this.outputLevel);
    }

    public boolean unsetOutputLevel() {
        if (this.isSetOutputLevel()) {
            Integer oldLevel = this.outputLevel;
            this.outputLevel = null;
            this.firePropertyChange("outputLevel", oldLevel, this.outputLevel);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            Output o = (Output)((Object)object);
            if ((equals &= o.isSetQualitativeSpecies() == this.isSetQualitativeSpecies()) && this.isSetQualitativeSpecies()) {
                equals &= o.getQualitativeSpecies().equals(this.getQualitativeSpecies());
            }
            if ((equals &= o.isSetTransitionEffect() == this.isSetTransitionEffect()) && this.isSetTransitionEffect()) {
                equals &= o.getTransitionEffect().equals((Object)this.getTransitionEffect());
            }
            if ((equals &= o.isSetOutputLevel() == this.isSetOutputLevel()) && this.isSetOutputLevel()) {
                equals &= o.getLevel() == this.getLevel();
            }
        }
        return equals;
    }

    public int hashCode() {
        int prime = 991;
        int hashCode = super.hashCode();
        if (this.isSetQualitativeSpecies()) {
            hashCode += 991 * this.getQualitativeSpecies().hashCode();
        }
        if (this.isSetTransitionEffect()) {
            hashCode += 991 * this.getTransitionEffect().hashCode();
        }
        if (this.isSetOutputLevel()) {
            hashCode += 991 * this.getLevel();
        }
        return hashCode;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("qualitativeSpecies")) {
                this.setQualitativeSpecies(value);
            } else if (attributeName.equals("outputLevel")) {
                this.setOutputLevel(StringTools.parseSBMLInt((String)value));
            } else if (attributeName.equals("transitionEffect")) {
                this.setTransitionEffect(OutputTransitionEffect.valueOf(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("qual:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("qual:name", this.getName());
        }
        if (this.isSetQualitativeSpecies()) {
            attributes.put("qual:qualitativeSpecies", this.getQualitativeSpecies());
        }
        if (this.isSetOutputLevel()) {
            attributes.put("qual:outputLevel", Integer.toString(this.getOutputLevel()));
        }
        if (this.isSetTransitionEffect()) {
            attributes.put("qual:transitionEffect", this.getTransitionEffect().toString());
        }
        return attributes;
    }

    public boolean containsUndeclaredUnits() {
        return false;
    }

    public UnitDefinition getDerivedUnitDefinition() {
        return null;
    }

    public String getDerivedUnits() {
        return null;
    }
}

