/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.InputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeAbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class InputConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020501, 3020510);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020501: {
                func = new AbstractValidationFunction<Input>(){

                    public boolean check(ValidationContext ctx, Input i) {
                        return new UnknownCoreAttributeAbstractValidationFunction().check(ctx, (TreeNodeWithChangeSupport)i, 3020501);
                    }
                };
                break;
            }
            case 3020502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020503: {
                func = new UnknownPackageAttributeValidationFunction<Input>("qual"){

                    public boolean check(ValidationContext ctx, Input i) {
                        if (!i.isSetQualitativeSpecies() || !i.isSetTransitionEffect()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)i);
                    }
                };
                break;
            }
            case 3020504: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020505: {
                func = new InvalidAttributeValidationFunction("sign");
                break;
            }
            case 3020506: {
                func = new InvalidAttributeValidationFunction("transitionEffect");
                break;
            }
            case 3020507: {
                func = new InvalidAttributeValidationFunction("thresholdLevel");
                break;
            }
            case 3020508: {
                func = new AbstractValidationFunction<Input>(){

                    public boolean check(ValidationContext ctx, Input i) {
                        if (i.isSetQualitativeSpecies() && i.getQualitativeSpeciesInstance() == null) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020508, (SBase)i, (String[])new String[]{i.getQualitativeSpecies()});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020509: {
                func = new AbstractValidationFunction<Input>(){

                    public boolean check(ValidationContext ctx, Input i) {
                        QualitativeSpecies qs;
                        if (i.isSetQualitativeSpecies() && i.isSetTransitionEffect() && (qs = i.getQualitativeSpeciesInstance()) != null && qs.isSetConstant() && qs.getConstant() && i.getTransitionEffect() == InputTransitionEffect.consumption) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020509, (SBase)i, (String[])new String[]{i.getQualitativeSpecies(), i.getId()});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020510: {
                func = new AbstractValidationFunction<Input>(){

                    public boolean check(ValidationContext ctx, Input i) {
                        if (i.isSetThresholdLevel() && i.getThresholdLevel() < 0) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020510, (SBase)i, (String[])new String[]{i.getId(), Integer.toString(i.getThresholdLevel())});
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

