/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.Transition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeAbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class TransitionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level >= 3) {
                    this.addRangeToSet(set, 3020401, 3020414);
                }
            }
            case MODELING_PRACTICE: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 3020401: {
                func = new AbstractValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        return new UnknownCoreAttributeAbstractValidationFunction().check(ctx, (TreeNodeWithChangeSupport)t, 3020401);
                    }
                };
                break;
            }
            case 3020402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 3020403: {
                func = new UnknownPackageAttributeValidationFunction("qual");
                break;
            }
            case 3020404: {
                func = new InvalidAttributeValidationFunction("name");
                break;
            }
            case 3020405: {
                func = new AbstractValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        Boolean functionTerm = false;
                        if (t.isSetListOfFunctionTerms() && t.getListOfFunctionTerms().size() > 0) {
                            functionTerm = new DuplicatedElementValidationFunction("listOfFunctionTerms").check(ctx, (TreeNodeWithChangeSupport)t);
                        }
                        Boolean input = new DuplicatedElementValidationFunction("listOfInputs").check(ctx, (TreeNodeWithChangeSupport)t);
                        Boolean output = new DuplicatedElementValidationFunction("listOfOutputs").check(ctx, (TreeNodeWithChangeSupport)t);
                        if (!(functionTerm != false && input != false && output != false)) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020405, (SBase)t, (String[])new String[]{Boolean.toString(t.isSetListOfFunctionTerms()), Boolean.toString(input), Boolean.toString(output)});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020406: {
                func = new AbstractValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfInputs() && t.getListOfInputs().isEmpty() || t.isSetListOfOutputs() && t.getListOfOutputs().isEmpty()) {
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020406, (SBase)t, (String[])new String[]{Integer.toString(t.getListOfInputs().size()), Integer.toString(t.getListOfOutputs().size())});
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020407: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfInputs() || t.getListOfInputs().isEmpty()) {
                            UnknownElementValidationFunction unFunc = new UnknownElementValidationFunction();
                            return unFunc.check(ctx, t.getListOfInputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020408: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfOutputs() || t.getListOfOutputs().isEmpty()) {
                            UnknownElementValidationFunction unFunc = new UnknownElementValidationFunction();
                            return unFunc.check(ctx, t.getListOfOutputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020409: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfFunctionTerms() && !t.getListOfFunctionTerms().isEmpty()) {
                            Boolean hasDefaultTerm = false;
                            for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                                if (!ft.isDefaultTerm()) continue;
                                hasDefaultTerm = true;
                            }
                            Boolean onlyDefaultTerm = new DuplicatedElementValidationFunction("defaultTerm").check(ctx, t.getListOfFunctionTerms());
                            Boolean onlyFuntionTermObjects = new UnknownElementValidationFunction().check(ctx, t.getListOfFunctionTerms());
                            return hasDefaultTerm != false && onlyDefaultTerm != false && onlyFuntionTermObjects != false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020410: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfInputs()) {
                            return new UnknownAttributeValidationFunction().check(ctx, t.getListOfInputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020411: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfOutputs()) {
                            return new UnknownAttributeValidationFunction().check(ctx, t.getListOfOutputs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020412: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        if (t.isSetListOfFunctionTerms()) {
                            return new UnknownAttributeValidationFunction().check(ctx, t.getListOfFunctionTerms());
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020413: {
                func = new ValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        int maxLevel = Integer.MIN_VALUE;
                        String QualSpecToExceed = "";
                        for (Output o : t.getListOfOutputs()) {
                            if (!o.isSetQualitativeSpecies() || o.getQualitativeSpeciesInstance() == null || !o.getQualitativeSpeciesInstance().isSetMaxLevel()) continue;
                            int newMaxLevel = o.getQualitativeSpeciesInstance().getMaxLevel();
                            if (newMaxLevel > maxLevel) {
                                QualSpecToExceed = o.getQualitativeSpecies();
                                maxLevel = newMaxLevel;
                            }
                            for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                                int resultLevel;
                                if (!ft.isSetResultLevel() || (resultLevel = ft.getResultLevel()) <= maxLevel) continue;
                                ValidationConstraint.logError((ValidationContext)ctx, (int)3020413, (SBase)t, (String[])new String[]{t.getId(), QualSpecToExceed});
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 3020414: {
                func = new AbstractValidationFunction<Transition>(){

                    public boolean check(ValidationContext ctx, Transition t) {
                        for (FunctionTerm ft : t.getListOfFunctionTerms()) {
                            if (!ft.isSetResultLevel() || ft.getResultLevel() >= 0) continue;
                            ValidationConstraint.logError((ValidationContext)ctx, (int)3020414, (SBase)t, (String[])new String[]{Integer.toString(ft.getResultLevel())});
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

