/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.awt.Color;
import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.XMLTools;

public class ColorDefinition
extends AbstractNamedSBase {
    private static final long serialVersionUID = 8904459123022343452L;
    private Color value;

    public ColorDefinition() {
        this.initDefaults();
    }

    public ColorDefinition(String id) {
        super(id);
        this.initDefaults();
    }

    public ColorDefinition(String id, Color value) {
        super(id);
        this.value = value;
        this.initDefaults();
    }

    public ColorDefinition(int level, int version) {
        this(null, null, level, version);
    }

    public ColorDefinition(String id, int level, int version) {
        this(id, null, level, version);
    }

    public ColorDefinition(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public ColorDefinition(ColorDefinition obj) {
        super((AbstractNamedSBase)obj);
        this.value = obj.value;
    }

    public ColorDefinition clone() {
        return new ColorDefinition(this);
    }

    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
    }

    public int hashCode() {
        int prime = 3109;
        int result = super.hashCode();
        result = 3109 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ColorDefinition other = (ColorDefinition)((Object)obj);
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public boolean isIdMandatory() {
        return true;
    }

    public Color getValue() {
        if (this.isSetValue()) {
            return this.value;
        }
        throw new PropertyUndefinedError("value", (SBase)this);
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValue(Color value) {
        Color oldValue = this.value;
        this.value = value;
        this.firePropertyChange("value", oldValue, this.value);
    }

    public boolean unsetValue() {
        if (this.isSetValue()) {
            Color oldValue = this.value;
            this.value = null;
            this.firePropertyChange("value", oldValue, this.value);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetValue()) {
            attributes.remove("value");
            attributes.put("render:value", XMLTools.encodeColorToString(this.getValue()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("value")) {
                this.setValue(XMLTools.decodeStringToColor(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

