/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.util.Arrays;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.Transformation2D;
import org.sbml.jsbml.ext.render.XMLTools;
import org.sbml.jsbml.util.StringTools;

public class GraphicalPrimitive1D
extends Transformation2D {
    private static final long serialVersionUID = 3705246334810811216L;
    protected String stroke;
    protected Short[] strokeDashArray;
    protected Double strokeWidth;

    public Short[] getStrokeDashArray() {
        if (this.isSetStrokeDashArray()) {
            return this.strokeDashArray;
        }
        throw new PropertyUndefinedError("stroke-dasharray", (SBase)this);
    }

    public boolean isSetStrokeDashArray() {
        return this.strokeDashArray != null;
    }

    public void setStrokeDashArray(Short[] strokeDashArray) {
        Short[] oldStrokeDashArray = this.strokeDashArray;
        this.strokeDashArray = strokeDashArray;
        this.firePropertyChange("stroke-dasharray", oldStrokeDashArray, this.strokeDashArray);
    }

    public boolean unsetStrokeDashArray() {
        if (this.isSetStrokeDashArray()) {
            Short[] oldStrokeDashArray = this.strokeDashArray;
            this.strokeDashArray = null;
            this.firePropertyChange("stroke-dasharray", oldStrokeDashArray, this.strokeDashArray);
            return true;
        }
        return false;
    }

    public GraphicalPrimitive1D() {
        this.initDefaults();
    }

    public GraphicalPrimitive1D(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public GraphicalPrimitive1D(GraphicalPrimitive1D obj) {
        this.stroke = obj.stroke;
        this.strokeWidth = obj.strokeWidth;
        if (obj.isSetStrokeDashArray()) {
            this.setStrokeDashArray((Short[])obj.strokeDashArray.clone());
        }
    }

    @Override
    public GraphicalPrimitive1D clone() {
        return new GraphicalPrimitive1D(this);
    }

    @Override
    public int hashCode() {
        int prime = 3181;
        int result = super.hashCode();
        result = 3181 * result + (this.stroke == null ? 0 : this.stroke.hashCode());
        result = 3181 * result + Arrays.hashCode((Object[])this.strokeDashArray);
        result = 3181 * result + (this.strokeWidth == null ? 0 : this.strokeWidth.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GraphicalPrimitive1D other = (GraphicalPrimitive1D)((Object)obj);
        if (this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.strokeDashArray, (Object[])other.strokeDashArray)) {
            return false;
        }
        return !(this.strokeWidth == null ? other.strokeWidth != null : !this.strokeWidth.equals(other.strokeWidth));
    }

    public String getStroke() {
        if (this.isSetStroke()) {
            return this.stroke;
        }
        throw new PropertyUndefinedError("stroke", (SBase)this);
    }

    public Double getStrokeWidth() {
        if (this.isSetStrokeWidth()) {
            return this.strokeWidth;
        }
        throw new PropertyUndefinedError("stroke-width", (SBase)this);
    }

    @Override
    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
    }

    public boolean isSetStroke() {
        return this.stroke != null;
    }

    public boolean isSetStrokeWidth() {
        return this.strokeWidth != null;
    }

    public void setStroke(String stroke) {
        String oldStroke = this.stroke;
        this.stroke = stroke;
        this.firePropertyChange("stroke", oldStroke, this.stroke);
    }

    public void setStrokeWidth(Double strokeWidth) {
        Double oldStrokeWidth = this.strokeWidth;
        this.strokeWidth = strokeWidth;
        this.firePropertyChange("stroke-width", oldStrokeWidth, this.strokeWidth);
    }

    public boolean unsetStroke() {
        if (this.isSetStroke()) {
            String oldStroke = this.stroke;
            this.stroke = null;
            this.firePropertyChange("stroke", oldStroke, this.stroke);
            return true;
        }
        return false;
    }

    public boolean unsetStrokeWidth() {
        if (this.isSetStrokeWidth()) {
            Double oldStrokeWidth = this.strokeWidth;
            this.strokeWidth = null;
            this.firePropertyChange("stroke-width", oldStrokeWidth, this.strokeWidth);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetStroke()) {
            attributes.remove("stroke");
            attributes.put("render:stroke-width", this.getStroke());
        }
        if (this.isSetStrokeDashArray()) {
            attributes.remove("stroke-dasharray");
            attributes.put("render:stroke-width", XMLTools.encodeArrayShortToString(this.getStrokeDashArray()));
        }
        if (this.isSetStrokeWidth()) {
            attributes.remove("stroke-width");
            attributes.put("render:stroke-width", this.getStrokeWidth().toString().toLowerCase());
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("stroke")) {
                this.setStroke(value);
            } else if (attributeName.equals("stroke-dasharray")) {
                this.setStrokeDashArray(XMLTools.decodeStringToArrayShort(value));
            } else if (attributeName.equals("stroke-width")) {
                this.setStrokeWidth(StringTools.parseSBMLDouble((String)value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

