/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.Transformation2D;
import org.sbml.jsbml.ext.render.XMLTools;

public class Image
extends Transformation2D {
    private static final long serialVersionUID = 6031110715160806863L;
    private Double x;
    private Double y;
    private Double z;
    private Double width;
    private Double height;
    private Boolean absoluteX;
    private Boolean absoluteY;
    private Boolean absoluteZ;
    private Boolean absoluteWidth;
    private Boolean absoluteHeight;
    private String href;

    public Image() {
        this.initDefaults();
    }

    public Image(String id) {
        this.initDefaults();
    }

    public Image(Image obj) {
        this.absoluteHeight = obj.absoluteHeight;
        this.absoluteWidth = obj.absoluteWidth;
        this.absoluteX = obj.absoluteX;
        this.absoluteY = obj.absoluteY;
        this.absoluteZ = obj.absoluteZ;
        this.height = obj.height;
        this.href = obj.href;
        this.width = obj.width;
        this.x = obj.x;
        this.y = obj.y;
        this.z = obj.z;
    }

    @Override
    public Image clone() {
        return new Image(this);
    }

    @Override
    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
        this.z = 0.0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.absoluteHeight == null ? 0 : this.absoluteHeight.hashCode());
        result = 31 * result + (this.absoluteWidth == null ? 0 : this.absoluteWidth.hashCode());
        result = 31 * result + (this.absoluteX == null ? 0 : this.absoluteX.hashCode());
        result = 31 * result + (this.absoluteY == null ? 0 : this.absoluteY.hashCode());
        result = 31 * result + (this.absoluteZ == null ? 0 : this.absoluteZ.hashCode());
        result = 31 * result + (this.height == null ? 0 : this.height.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
        result = 31 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 31 * result + (this.y == null ? 0 : this.y.hashCode());
        result = 31 * result + (this.z == null ? 0 : this.z.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)((Object)obj);
        if (this.absoluteHeight == null ? other.absoluteHeight != null : !this.absoluteHeight.equals(other.absoluteHeight)) {
            return false;
        }
        if (this.absoluteWidth == null ? other.absoluteWidth != null : !this.absoluteWidth.equals(other.absoluteWidth)) {
            return false;
        }
        if (this.absoluteX == null ? other.absoluteX != null : !this.absoluteX.equals(other.absoluteX)) {
            return false;
        }
        if (this.absoluteY == null ? other.absoluteY != null : !this.absoluteY.equals(other.absoluteY)) {
            return false;
        }
        if (this.absoluteZ == null ? other.absoluteZ != null : !this.absoluteZ.equals(other.absoluteZ)) {
            return false;
        }
        if (this.height == null ? other.height != null : !this.height.equals(other.height)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.width == null ? other.width != null : !this.width.equals(other.width)) {
            return false;
        }
        if (this.x == null ? other.x != null : !this.x.equals(other.x)) {
            return false;
        }
        if (this.y == null ? other.y != null : !this.y.equals(other.y)) {
            return false;
        }
        return !(this.z == null ? other.z != null : !this.z.equals(other.z));
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getChildCount() {
        int count = 0;
        return count;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(childIndex + " < 0");
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", childIndex, Math.min(pos, 0)));
    }

    public boolean isAbsoluteHeight() {
        if (this.isSetAbsoluteHeight()) {
            return this.absoluteHeight;
        }
        return true;
    }

    public boolean isSetAbsoluteHeight() {
        return this.absoluteHeight != null;
    }

    public void setAbsoluteHeight(Boolean absoluteHeight) {
        Boolean oldAbsoluteHeight = this.absoluteHeight;
        this.absoluteHeight = absoluteHeight;
        this.firePropertyChange("absolute-height", oldAbsoluteHeight, this.absoluteHeight);
    }

    public boolean unsetAbsoluteHeight() {
        if (this.isSetAbsoluteHeight()) {
            Boolean oldAbsoluteHeight = this.absoluteHeight;
            this.absoluteHeight = null;
            this.firePropertyChange("absolute-height", oldAbsoluteHeight, this.absoluteHeight);
            return true;
        }
        return false;
    }

    public boolean isAbsoluteWidth() {
        if (this.isSetAbsoluteWidth()) {
            return this.absoluteWidth;
        }
        return true;
    }

    public boolean isSetAbsoluteWidth() {
        return this.absoluteWidth != null;
    }

    public void setAbsoluteWidth(Boolean absoluteWidth) {
        Boolean oldAbsoluteWidth = this.absoluteWidth;
        this.absoluteWidth = absoluteWidth;
        this.firePropertyChange("absolute-width", oldAbsoluteWidth, this.absoluteWidth);
    }

    public boolean unsetAbsoluteWidth() {
        if (this.isSetAbsoluteWidth()) {
            Boolean oldAbsoluteWidth = this.absoluteWidth;
            this.absoluteWidth = null;
            this.firePropertyChange("absolute-width", oldAbsoluteWidth, this.absoluteWidth);
            return true;
        }
        return false;
    }

    public boolean isAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            return this.absoluteX;
        }
        return true;
    }

    public boolean isSetAbsoluteX() {
        return this.absoluteX != null;
    }

    public void setAbsoluteX(Boolean absoluteX) {
        Boolean oldAbsoluteX = this.absoluteX;
        this.absoluteX = absoluteX;
        this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
    }

    public boolean unsetAbsoluteX() {
        if (this.isSetAbsoluteX()) {
            Boolean oldAbsoluteX = this.absoluteX;
            this.absoluteX = null;
            this.firePropertyChange("absolute-x", oldAbsoluteX, this.absoluteX);
            return true;
        }
        return false;
    }

    public boolean isAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            return this.absoluteY;
        }
        return true;
    }

    public boolean isSetAbsoluteY() {
        return this.absoluteY != null;
    }

    public void setAbsoluteY(Boolean absoluteY) {
        Boolean oldAbsoluteY = this.absoluteY;
        this.absoluteY = absoluteY;
        this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
    }

    public boolean unsetAbsoluteY() {
        if (this.isSetAbsoluteY()) {
            Boolean oldAbsoluteY = this.absoluteY;
            this.absoluteY = null;
            this.firePropertyChange("absolute-y", oldAbsoluteY, this.absoluteY);
            return true;
        }
        return false;
    }

    public boolean isAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            return this.absoluteZ;
        }
        return true;
    }

    public boolean isSetAbsoluteZ() {
        return this.absoluteZ != null;
    }

    public void setAbsoluteZ(Boolean absoluteZ) {
        Boolean oldAbsoluteZ = this.absoluteZ;
        this.absoluteZ = absoluteZ;
        this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
    }

    public boolean unsetAbsoluteZ() {
        if (this.isSetAbsoluteZ()) {
            Boolean oldAbsoluteZ = this.absoluteZ;
            this.absoluteZ = null;
            this.firePropertyChange("absolute-z", oldAbsoluteZ, this.absoluteZ);
            return true;
        }
        return false;
    }

    public double getHeight() {
        if (this.isSetHeight()) {
            return this.height;
        }
        throw new PropertyUndefinedError("height", (SBase)this);
    }

    public boolean isSetHeight() {
        return this.height != null;
    }

    public void setHeight(Double height) {
        Double oldHeight = this.height;
        this.height = height;
        this.firePropertyChange("height", oldHeight, this.height);
    }

    public boolean unsetHeight() {
        if (this.isSetHeight()) {
            Double oldHeight = this.height;
            this.height = null;
            this.firePropertyChange("height", oldHeight, this.height);
            return true;
        }
        return false;
    }

    public String getHref() {
        if (this.isSetHref()) {
            return this.href;
        }
        throw new PropertyUndefinedError("href", (SBase)this);
    }

    public boolean isSetHref() {
        return this.href != null;
    }

    public void setHref(String href) {
        String oldHref = this.href;
        this.href = href;
        this.firePropertyChange("href", oldHref, this.href);
    }

    public boolean unsetHref() {
        if (this.isSetHref()) {
            String oldHref = this.href;
            this.href = null;
            this.firePropertyChange("href", oldHref, this.href);
            return true;
        }
        return false;
    }

    public double getWidth() {
        if (this.isSetWidth()) {
            return this.width;
        }
        throw new PropertyUndefinedError("width", (SBase)this);
    }

    public boolean isSetWidth() {
        return this.width != null;
    }

    public void setWidth(Double width) {
        Double oldWidth = this.width;
        this.width = width;
        this.firePropertyChange("width", oldWidth, this.width);
    }

    public boolean unsetWidth() {
        if (this.isSetWidth()) {
            Double oldWidth = this.width;
            this.width = null;
            this.firePropertyChange("width", oldWidth, this.width);
            return true;
        }
        return false;
    }

    public double getX() {
        if (this.isSetX()) {
            return this.x;
        }
        throw new PropertyUndefinedError("x", (SBase)this);
    }

    public boolean isSetX() {
        return this.x != null;
    }

    public void setX(Double x) {
        Double oldX = this.x;
        this.x = x;
        this.firePropertyChange("x", oldX, this.x);
    }

    public boolean unsetX() {
        if (this.isSetX()) {
            Double oldX = this.x;
            this.x = null;
            this.firePropertyChange("x", oldX, this.x);
            return true;
        }
        return false;
    }

    public double getY() {
        if (this.isSetY()) {
            return this.y;
        }
        throw new PropertyUndefinedError("y", (SBase)this);
    }

    public boolean isSetY() {
        return this.y != null;
    }

    public void setY(Double y) {
        Double oldY = this.y;
        this.y = y;
        this.firePropertyChange("y", oldY, this.y);
    }

    public boolean unsetY() {
        if (this.isSetY()) {
            Double oldY = this.y;
            this.y = null;
            this.firePropertyChange("y", oldY, this.y);
            return true;
        }
        return false;
    }

    public double getZ() {
        if (this.isSetZ()) {
            return this.z;
        }
        throw new PropertyUndefinedError("z", (SBase)this);
    }

    public boolean isSetZ() {
        return this.z != null;
    }

    public void setZ(Double z) {
        Double oldZ = this.z;
        this.z = z;
        this.firePropertyChange("z", oldZ, this.z);
    }

    public boolean unsetZ() {
        if (this.isSetZ()) {
            Double oldZ = this.z;
            this.z = null;
            this.firePropertyChange("z", oldZ, this.z);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetHref()) {
            attributes.remove("href");
            attributes.put("render:href", this.getHref());
        }
        if (this.isSetX()) {
            attributes.remove("x");
            attributes.put("render:x", XMLTools.positioningToString(this.getX(), this.isAbsoluteX()));
        }
        if (this.isSetY()) {
            attributes.remove("y");
            attributes.put("render:y", XMLTools.positioningToString(this.getY(), this.isAbsoluteY()));
        }
        if (this.isSetZ()) {
            attributes.remove("z");
            attributes.put("render:z", XMLTools.positioningToString(this.getZ(), this.isAbsoluteZ()));
        }
        if (this.isSetWidth()) {
            attributes.remove("width");
            attributes.put("render:width", XMLTools.positioningToString(this.getWidth(), this.isAbsoluteWidth()));
        }
        if (this.isSetHeight()) {
            attributes.remove("height");
            attributes.put("render:height", XMLTools.positioningToString(this.getHeight(), this.isAbsoluteHeight()));
        }
        return attributes;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("href")) {
                this.setHref(value);
            } else if (attributeName.equals("x")) {
                this.setX(XMLTools.parsePosition(value));
                this.setAbsoluteX(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("y")) {
                this.setY(XMLTools.parsePosition(value));
                this.setAbsoluteY(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("z")) {
                this.setZ(XMLTools.parsePosition(value));
                this.setAbsoluteZ(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("width")) {
                this.setWidth(XMLTools.parsePosition(value));
                this.setAbsoluteWidth(XMLTools.isAbsolutePosition(value));
            } else if (attributeName.equals("height")) {
                this.setHeight(XMLTools.parsePosition(value));
                this.setAbsoluteHeight(XMLTools.isAbsolutePosition(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

