/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.render;

import java.text.MessageFormat;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.render.GraphicalPrimitive2D;
import org.sbml.jsbml.ext.render.RenderPoint;

public class Polygon
extends GraphicalPrimitive2D {
    private static final long serialVersionUID = 9207043017589271103L;
    private ListOf<RenderPoint> listOfElements;

    public Polygon() {
        this.initDefaults();
    }

    public Polygon(Polygon obj) {
        super(obj);
        this.setListOfElements((ListOf<RenderPoint>)obj.getListOfElements().clone());
    }

    public boolean addElement(RenderPoint element) {
        return this.getListOfElements().add((SBase)element);
    }

    @Override
    public Polygon clone() {
        return new Polygon(this);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(childIndex + " < 0");
        }
        int pos = 0;
        if (this.isSetListOfElements()) {
            if (pos == childIndex) {
                return this.getListOfElements();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfElements()) {
            ++count;
        }
        return count;
    }

    public ListOf<RenderPoint> getListOfElements() {
        if (this.isSetListOfElements()) {
            return this.listOfElements;
        }
        throw new PropertyUndefinedError("list-of-elements", (SBase)this);
    }

    @Override
    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
    }

    public boolean isSetListOfElements() {
        return this.listOfElements != null;
    }

    public void setListOfElements(ListOf<RenderPoint> listOfElements) {
        ListOf<RenderPoint> oldListOfElements = this.listOfElements;
        if (listOfElements != null) {
            this.listOfElements = listOfElements;
            this.registerChild((SBase)this.listOfElements);
            this.firePropertyChange("list-of-elements", oldListOfElements, this.listOfElements);
        }
    }

    public boolean unsetListOfElements() {
        if (this.isSetListOfElements()) {
            ListOf<RenderPoint> oldListOfElements = this.listOfElements;
            this.listOfElements = null;
            this.firePropertyChange("list-of-elements", oldListOfElements, this.listOfElements);
            return true;
        }
        return false;
    }
}

